/* $Id: comptypes.h,v 10.1 92/10/06 23:08:10 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

/* components of MaRS */

#ifndef COMPTYPES_H
#define COMPTYPES_H
/* File that defines the different types of components in the particular
   model being implemented.  Will vary with different implementations.  */

#include "sim.h"

caddr_t link_action(), node_action(), spf_action(), segal_action(),
        exBF_ack_action(),exBF_action(), ftp_source_action(), 
        ftp_sink_action(), pm_action(),
        SmplTrfc_source_action(), SmplTrfc_sink_action(), stopper_action(),
        telnet_source_action(), telnet_sink_action(), lcostfcn_action();

typedef struct {
  char		typename[40];
  short		class;		/* What class this component is */
  PFP		action;
  int		*parent_types; /* eric added */
} Component_type;

/* Classes of components */
#define OTHER_CLASS	0
#define LINK_CLASS	1
#define NODE_CLASS	2
#define ROUTE_CLASS	3
#define APTR_CLASS	4
#define AUXILIARY_CLASS	5

/* Types of components.  These numbers must be indexes into
   the component_types[] array.  They are also supposed to be
   constants.  (They are not #define's only so that the nubmers
   can be changed without recompiling everything that uses them.) */

/* CONST is defined in sim.h. */

#define LINK			0
#define NODE			1
#define SPF			2
#define SEGAL			3
#define EXBF		        4
#define EXBF_ACK                5
#define FTP_SOURCE 		6
#define FTP_SINK        	7	
#define TELNET_SOURCE   	8 	
#define TELNET_SINK     	9 
#define SMPLTRFC_SOURCE 	10
#define SMPLTRFC_SINK   	11
#define PERF_MONITOR    	12
#define STOPPER		    	13
#define LCOSTFCN	    	14

extern Component_type component_types[];

#endif   /* COMPTYPES_H   */



