/* $Id: eventdefs.h,v 10.1 92/10/06 23:08:31 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef EVENTDEFS_H
#define EVENTDEFS_H
/** Define types of events. */

/* Classes of events */
#define EV_CLASS_EVENT	 0x01000000	/* Normal event-- eg RECEIVE */
#define EV_CLASS_PRIVATE 0x02000000	/* Event sent to self */
#define EV_CLASS_CMD	 0x04000000	/* Command-- eg INITIALIZE */
#define EV_CLASS_RECORD	 0x08000000	/* Events that should be recorded
					   eg FAILURE/REPAIR */

/* Events: */

/* Commands: all components must accept these (don't have to actually
   do anything with them, but shouldn't complain about them). */
#define EV_RESET 	(EV_CLASS_CMD | 1) /* Reset the component */
#define EV_CREATE 	(EV_CLASS_CMD | 2) /* Initialize and create the comp.
					   Must be sent to a component before
					   any other events are received, and
					   never again. */
#define EV_DEL 		(EV_CLASS_CMD | 3) /* Clean up before deletion.
					   Must be received only once, and
					   the action routine must not be
					   called again afterward.  */
#define EV_NEIGHBOR 	(EV_CLASS_CMD | 4) /* Make passed comp. your neighbor */
#define EV_UNEIGHBOR	(EV_CLASS_CMD | 5) /* Detach self from passed comp. */
#define EV_START 	(EV_CLASS_CMD | 6) /* Start going */
#define EV_MK_PEER 	(EV_CLASS_CMD | 7) /* make peer connections, routers */
#define EV_STOP 	(EV_CLASS_CMD | 8) /* tell the component it is over */

/* Events that have to do with running the simulator */
#define EV_LINK_SEND		(EV_CLASS_EVENT | 1)

#define EV_NODE_RECEIVE		(EV_CLASS_EVENT | 2)
#define EV_NODE_SEND		(EV_CLASS_EVENT | 3)
#define EV_NODE_PRODUCE		(EV_CLASS_EVENT | 4)/*external input to node */

#define EV_ROUTE_PROCESSING	(EV_CLASS_EVENT | 5) 

#define EV_APTR_RECEIVE		(EV_CLASS_EVENT | 6)	
#define EV_APTR_RETRANSMIT	(EV_CLASS_EVENT | 7)	
#define EV_INSTANT_RATE      	(EV_CLASS_EVENT | 8)

#define EV_APTR_CONN_ON		(EV_CLASS_RECORD | 1)
#define EV_NODE_FAILURE 	(EV_CLASS_RECORD | 2)
#define EV_NODE_REPAIR  	(EV_CLASS_RECORD | 3)
#define EV_LINK_FAILURE		(EV_CLASS_RECORD | 4)
#define EV_LINK_REPAIR		(EV_CLASS_RECORD | 5)

#endif   /* EVENTDEFS_H   */
