/* $Id $ */
#ifndef EXBF_H
#define EXBF_H
/*
 * Routing Module Data Structures for Extended BF Algorithm
 * 
 * by  Ibrahim Matta
 * Nov 9, 1990
 */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"
#include "route.h"

#define EV_START_COMPUTATION	   	(EV_CLASS_PRIVATE | 1)


caddr_t exBF_action();

typedef struct {
   Component	*dest;	        	/* Pointer to node sink */
   unsigned int	cost;	        	/* Estimated cost to node sink */
                                           
   unsigned int	cost_via[MAX_LINKS];	/* Estimated cost thru neighbour nodes */
   Component 	*head_via[MAX_LINKS]; 	/* Head of the path thru */
                                        /* neighbour nodes */
} DistanceTable[MAX_NO_OF_NODES];

typedef struct _ExBFt {
  struct _ExBFt *exBF_next,	    /* Links to other components in the list */
                *exBF_prev;

  short         exBF_class;	    /*  */
  short		exBF_type;	    /*  */
  char		exBF_name[40];	    /* Name of component (appears on screen) */
  PFP		exBF_action;  	    /* Main function of component.  */
  COMP_OBJECT	exBF_picture;	    /* Graphics object displays this thing */
  list		*exBF_neighbors;   /* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */

  short		exBF_menu_up;	    /* If true, then the text window is up */
  queue		*exBF_params;	    /* Variable-length queue of parameters */

  PFI		processing_time;    /* returns an estimate of proc time */
  int		no_of_nodes;	    /* seen no of nodes in the net */
  tick_t	link_cost_time;	    /* time at which link costs are calculated*/
  Component	*node;		    /* my neighbour node */

  Param		*routing_table;	    /* routing table */
  Param		*local_top;	    /* local topology table */
  Param		*distance_table;    /* Distance table */   
  Param		*brdcast_period;    /* time btw start events */
  Param		*sd;    	    /* deviation */
  unsigned int old_cost_via[MAX_LINKS]; /* Used to check changes in */
                                        /* link weights */
  Component	*head[MAX_NO_OF_NODES];	/* Head of the path in routing table */

} ExBFt;
#endif   /* EXBF_H */









