/* $Id: exBF_ack.h,v 10.1 92/10/06 23:08:34 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef EXBFa_H
#define EXBFa_H
/*
 * Routing Module Data Structures for Extended BF Algorithm
 * 
 */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"
#include "route.h"

#define EV_START_COMPUTATION	   	(EV_CLASS_PRIVATE | 1)


caddr_t exBF_ack_action();

typedef struct {
   Component	*dest;	        	/* Pointer to node sink */
   unsigned int	cost;	        	/* Estimated cost to node sink */
                                           
   unsigned int	cost_via[MAX_LINKS];	/* Estimated cost thru neighbour nodes */
   Component 	*head_via[MAX_LINKS]; 	/* Head of the path thru */
                                        /* neighbour nodes */
} DistanceTable[MAX_NO_OF_NODES];

typedef struct _ExBFat {
  struct _ExBFat *exBFa_next,	    /* Links to other components in the list */
                *exBFa_prev;

  short         exBFa_class;	    /*  */
  short		exBFa_type;	    /*  */
  char		exBFa_name[40];	    /* Name of component (appears on screen) */
  PFP		exBFa_action;       /* Main function of component.  */
  COMP_OBJECT	exBFa_picture;	    /* Graphics object displays this thing */
  list		*exBFa_neighbors;   /* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */

  short		exBFa_menu_up;	    /* If true, then the text window is up */
  queue		*exBFa_params;	    /* Variable-length queue of parameters */

  PFI		processing_time;    /* returns an estimate of proc time */
  int		no_of_nodes;	    /* seen no of nodes in the net */
  tick_t	link_cost_time;	    /* time at which link costs are calculated*/
  Component	*node;		    /* my neighbour node */

  Param		*routing_table;	    /* routing table */
  Param		*local_top;	    /* local topology table */
  Param		*distance_table;    /* Distance table */   
  Param		*brdcast_period;    /* time btw start events */
  Param		*sd;    	    /* deviation */
  unsigned int old_cost_via[MAX_LINKS]; /* Used to check changes in */
                                        /* link weights */
  Component	*head[MAX_NO_OF_NODES];	/* Head of the path in routing table */
  Component 	*temp_hop[MAX_NO_OF_NODES]; /* switch to new preferred
					       neighbors when acks from all
					       neighbors are received */
  int		num_ack[MAX_LINKS];

} ExBFat;
#endif   /* EXBFa_H */









