/* $Id: ftp.h,v 10.1 92/10/06 23:08:35 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef FTP_H
#define FTP_H
/*
 * Application Transport Module
 * 
 */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"

#define EV_APTR_PRODUCE      (EV_CLASS_PRIVATE | 1)
#define EV_APTR_CONSUME      (EV_CLASS_PRIVATE | 2)
#define EV_APTR_SEND         (EV_CLASS_PRIVATE | 3)

caddr_t ftp_source_action();
caddr_t ftp_sink_action();

/*
 * Variation of component structure for ftp
 */
typedef struct _Ftpt {
  struct _Ftpt *ftp_next,	    /* Links to other components in the list */
                *ftp_prev;

  short         ftp_class;	    /*  */
  short		ftp_type;	    /*  */
  char		ftp_name[40];	    /* Name of component (appears on screen) */
  PFP		ftp_action;  	    /* Main function of component.  */
  COMP_OBJECT	ftp_picture;	    /* Graphics object displays this thing */
  list		*ftp_neighbors;     /* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */

  short		ftp_menu_up;	    /* If true, then the text window is up */
  queue		*ftp_params;	    /* Variable-length queue of parameters */

  Socket	source_socket;		/* (host aptr) of source */
  Socket	dest_socket;		/* (host aptr) of destination */
  Param		*ftp_peer;		/* (host.name aptr.name) of dest */

  Param		*ftp_select;		/* flag to select this conn */
  Param		*ftp_produce_ws;	/* produce window size */
  Param		*ftp_send_ws;		/* send window size */

  Param		*ftp_packets_produced;  /* no of data packets produced */
  Param		*ftp_packets_sent;	/* no of data packets send */
  Param		*ftp_packets_acked;	/* no of data packets acked */
  Param		*ftp_packets_recvd;	/* no of data packets received */
  Param		*ftp_packets_retransmitted;/* no of datapackets retransmitted */
  int		ftp_token_time;	        /* time when the token last sent */
  Param		*ftp_rtt;		/* round trip time estimate */

  Param		*ftp_tr_delay;	    	/* integer; usecs between trains */
  Param		*ftp_tr_how_many;  	/* Number of trains  */
  Param		*ftp_car_how_many; 	/* Number of cars in this train  */
  Param		*ftp_car_per_tr; 	/* Number of cars per train  */
  Param		*ftp_car_delay;    	/* integer; usecs between cars */
  Param		*ftp_car_length;   	/* integer; packet size */
  Param         *ftp_current_train;	/* Number of the train being sent */
  Param         *ftp_current_car;  	/* Number of the car being sent */

  Param		*init_conn_on_off; 	/* how should the connection start */
  Param		*conn_on_off;	        /* whether the connection is on/off */
  int		conn_start_time;	 
  int		no_of_current_conns;    /* Useful only if end of the previous 
					   train overlaps with the next train */
  int		no_of_total_cars;
  
  Param		*sent_thruput;		
  Param		*acked_thruput;

  Param		*inst_delay;		/* Inst delay of a packet from    */
					/* the time it was sent to the 	  */
					/* time it was acked		  */

  Param		*retransmission_rate;


  int   	total_prev_bytes_acked;  /* Used to compute instantaneous   */
  int		ftp_bytes_sent;          /* sent, acked, and retrans. rates */
  int 		ftp_bytes_retransmitted;

  int   	total_delay;		/* Used to compute inst delay for */
  int 		recent_pkts_acked;      /* this connection */

  int		last_pkt_delay; 	/* needed by perf mon */
  int		data_acked;	 	/* needed by perf mon */
  int		last_bytes_acked;

  int		produce_scheduled;      /* an internal flag */

} Ftpt;
#endif   /* FTP_H */

