/* $Id: lcostfcn.h,v 10.1 92/10/06 23:08:40 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef LCOSTFCN_H
#define LCOSTFCN_H

#include "sim.h"
#include "q.h"
#include "list.h"
#include "simx1.h"		/* for GRAF_OBJECT & COMP_OBJECT */

caddr_t lcostfcn_action();

typedef struct _Lcostfcn {
   struct _Lcostfcn
                *next, *prev; 
   short	class;		/* Class of LCOSTFCN */
   short	type;		/* Type of LCOSTFCN that I am. */
   char		name[40];	/* Name of LCOSTFCN (appears on screen) */
   PFP		action;		/* Main function of LCOSTFCN.*/
   COMP_OBJECT	picture;	/* Graphics object that displays this thing */
   
   list		*neighbors;	/* Doubly linked list of neighbors. */
   
   short	menu_up;	/* If true, then the text window is up */
   queue	*params;	/* Variable-length queue of parameters */
   
   Param	*link_cost_function;
   Param	*min_delay;
   Param	*max_delay;
   Param	*slope;
   Param	*offset;
   Param	*movement_limit;
   Param	*maximum;
   Param	*minimum;
   Param	*exp_filter;
} Lcostfcn;

extern Lcostfcn *lcostfcn_adr;

#endif LCOSTFCN_H

