/* $Id: link.h,v 10.1 92/10/06 23:08:41 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef LINK_H
#define LINK_H
/*
 link.h          

 */
#include "sim.h"
#include "event.h"
#include "q.h"
#include "list.h"
#include "component.h"

#define EV_LINK_RECEIVE     (EV_CLASS_PRIVATE | 1)

caddr_t link_action();

/*
 Link - Structure
*/
typedef struct _Link {
  struct _Link *link_next,     	        /* Links to other components in the list */
               *link_prev;

  short         link_class;	        /*  */
  short		link_type;	        /*  */
  char		link_name[40];	        /* Name of component (appears on screen) */
  PFP		link_action;  	        /* Main function of component.  */
  COMP_OBJECT	link_picture;	        /* Graphics object displays this thing */
  list		*link_neighbors;        /* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */

  short		link_menu_up;	        /* If true, then the text window is up */
  queue		*link_params;           /* Variable-length queue of parameters */

  Param		*link_propagation_delay;/* Length of the link */
  Param		*link_bandwidth;        /* Bandwidth of the link in bytes/sec. */
  Param		*link_failure_time;   	/* Parameter for the failure model */
  Param		*dist_failure;          /* Parameter to indicate what distribution 
                                           to use for times btw failures */
  Param		*sd_failure;		/* Standard deviation for uniform dist for failures */
  Param         *link_repair_time;  	/* Parameter for the repair model */
  Param		*dist_repair;           /* Parameter to indicate what distribution 
                                           to use for the repair times */
  Param		*sd_repair;		/* Standard deviation for uniform dist for repairs */
  Param         *link_status;       	/* Status of the link */
  Param         *failure_status;       	/* Indicates who caused the failure */
 
  Param         *idata_util_1;          /* Utilization of lq1 in terms of data/ack/token packets*/
  Param         *irout_util_1;          /* Utilization of lq1 in terms of routing packets*/

  Param         *idata_util_2;          /* Utilization of lq2 in terms of data/ack/token packets*/
  Param         *irout_util_2;          /* Utilization of lq2 in terms of routing packets*/

  int           data_bytes_1;           /* data/ack/token bytes sent on link 1 since last util update */
  int           rout_bytes_1;           /* routing bytes sent on link 1 since last util update */
  int           data_bytes_2;           /* data/ack/token bytes sent on link 2 since last util update */
  int           rout_bytes_2;           /* routing bytes sent on link 2 since last util update */

  int           bytes_in_dt;            /* max number of bytes transmitted in dt */

  queue         *link_queue_1;          /* Packet queue in one direction */
  queue         *link_queue_2;          /* Packet queue in the second direction */
  Event		*next_rcv_ev_1;		/* Next recv event for 1st direction */
  Event		*next_rcv_ev_2;		/* Next recv event for 2st direction */


} Link;
#endif  

