#ifndef LOG_H
#define LOG_H
/* $Id: log.h,v 10.1 92/10/06 23:08:44 ca Exp $ */

#include "component.h"
#include "event.h"

/* Header file describing structures used in the log cluster. */

typedef FILE *Log;

Log dbg_create();
void dbg_param_close();

void log_packet_sequence(), log_a_packet(), log_ack_sequence();

/* Length of line written by the packet logger, including newline. */
#define PACKET_LOG_LINE_LENGTH 42

/* inline stuff for use with GCC. */
#ifdef INLINE
#ifdef LOGSOURCE
FILE *log_fp = NULL;
int dbg_level = 0;
#else   /* if not LOG */
extern FILE *log_fp;
extern int dbg_level;
#endif  /* LOGSOURCE */

static inline
dbg_set_level(level)
     int level;
{
  int temp = dbg_level;

  dbg_level = level;
  return(temp);
}

/* Set the change mask in the parameter, and also log it if necessary. */
static inline
log_param(c, p)
     Component *c;
     Param *p;
{
  char b[80];

  p->p_flags |= ChangeMask;

  if (p->p_flags & LogMask && p->p_log)
    fprintf(log_fp, "%d %u %s\n", p->p_log, ev_now(),
	    (*p->p_make_short_text)(c, p));
}

#endif   /* INLINE */
#endif   /* LOG_H   */
