#ifndef MEMPOOL_H
#define MEMPOOL_H
/* $Id: mempool.h,v 10.1 92/10/06 23:08:46 ca Exp $ */

#include "sim.h"
#include "q.h"

/* Header file for the memory pool */

typedef struct _Mempool {
  queue *mp_free;		/* List of free envelopes */
  queue *mp_mem_chunks;		/* List of big chunks of memory allocated */
  unsigned mp_data_size, mp_how_many;
  unsigned mp_envs_per_rec;
} Mempool;

typedef struct _MemEnvelope {
  struct _MemEnvelope *me_next, *me_prev;
} MemEnvelope;

void mp_destroy(), mp_stat(), mp_free_all();
Mempool *mp_init();

/** Make two commonly used functions inline if using GCC */
#ifdef INLINE

static inline caddr_t
mp_alloc(mp)
     register Mempool *mp;
{
#ifdef MEMPOOL
  register MemEnvelope *me;

  me = (MemEnvelope *)qe_deq(mp->mp_free);
  if (!me)  {
    mp_more_mem(mp);
    me = (MemEnvelope *)qe_deq(mp->mp_free);
  }

  /* Skip past header info to return memory */
  return((caddr_t)(me + 1));
#else  /* MEMPOOL */
  return((caddr_t)sim_malloc(mp->mp_data_size));
#endif /* MEMPOOL */
}
     
static inline void
mp_free(mp, p)
     register Mempool *mp;
     register char *p;
{
#ifdef MEMPOOL
  /* P is a pointer to the memory that had been mp_alloc()'ed.  To get
     to the header info, just cast it to a MemEnvelope * and subtract 1 */

  register MemEnvelope *me = ((MemEnvelope *)p) - 1;

  qe_addt(mp->mp_free, me);
#else  /* MEMPOOL */
  free(p);
#endif /* MEMPOOL */
}

#else  /* if not INLINE */
caddr_t mp_alloc();
void mp_free();
#endif  /* INLINE */
#endif   /* MEMPOOL_H   */
