/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
/* $Id: xm-meters.h,v 10.1 92/10/06 23:09:29 ca Exp $ */
#ifndef NoX
#ifndef METERS_H
#define METERS_H

#include "simx.h"

typedef struct _METERTYPE
{
  char meter_name[30];
  int meter_type;
  double height;
  double width;

} METERTYPE;

extern METERTYPE meter_types[];

typedef struct {
  char string[30];
} METERINFOSTRING;


typedef struct {
  int time_increment;
  int data_head;
  int data_tail;
  int data_length;
  int time;
  double *data_array;
  double counter;
  double divider;
} TH;

typedef struct {
  int data_head;	/* oldest sample */
  int data_samples;	/* max number of samples retained */
  int data_obs;		/* current number of samples */
  double *data_array;   /* table of samples */
  int	 *hist_array;   /* table of cells */
  double hist_min;      /* least sample value recorded */
  double hist_max;	/* greatest sample value recorded */
  double hist_intrvl;	/* (hist_max - hist_min) / hist_cells */
  int    hist_cells;    /* how many cells */
} HISTO_METER;

#ifndef MOTIF

#define METER_HEIGHT 30
#define METER_WIDTH 150
#define METER_X 500
#define METER_Y 500

typedef struct  {
  Param *parameter;
  COMPONENT *scomponent;
  TH *th;
  HISTO_METER *hist;
  Window meter_window;
  Window info_window;
  char name[20];
  short display_name;
  short display_scale;
  int x,y;
  int width, height;
  int info_x, info_y;
  int info_width, info_height;
  short logging;
  short type;
} METER;

#else

extern list* m_list;   /* The XMotif module uses 1 global m_list, not one for each component. */

typedef struct  {
  Param *parameter;
  COMPONENT *scomponent;
  MComponent *meter_comp;
  TH *th;
  HISTO_METER *hist;
  Widget meter_window;
  Widget label;
  Widget draw_area;
  Widget info_window;
  Widget *textfields;  /* textfields in the meter information window. */
  int num_textfields;
  char name[20];
  short display_name;
  short display_scale;
  int x,y;
  int width, height;
  short logging;
  short type;
} METER;

void open_meter_info_w_tn(Widget w);
void close_meter_info_w_tn(Widget w);
void open_close_meter_info_w_tn(Widget w);

void move_meter(Widget w, XButtonEvent *event, String *argv, int *argc);
void resize_meter(Widget w, XButtonEvent *event, String *argv, int *argc);
void raise_meter(Widget w);
void lower_meter(Widget w);

Widget BuildMeterInfoWindow(METER *meter);
void OpenMeterInfoWindow(METER *meter, int x, int y, int valid_coords);
void CloseMeterInfoWindow(METER *meter);
int CreateMeter(COMPONENT *scomponent, PARAM *parameter, char *name, int oldx, int oldy, int oldwidth, int oldheight, int draw_component);
int DestroyMeter (COMPONENT *scomponent, PARAM *parameter);

#endif /* MOTIF */
#endif   /* METERS_H   */
#endif /* NoX */
