/* $Id: node.h,v 10.1 92/10/06 23:08:49 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef NODE_H
#define NODE_H


#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"
#include "route.h"


#define time_to_fail(nd) 	 random_no(nd->dist_chosen_fail->u.i, \
                                        (double) nd->nd_time_btw_fails->u.i, \
                                        (double) nd->sd_fail->u.d, \
                                        (unsigned) 1, \
                                        (unsigned) 10000000) 

#define time_to_repair(nd)  	random_no(nd->dist_chosen_repair->u.i, \
                                        (double) nd->nd_time_for_repair->u.i, \
                                        (double) nd->sd_repair->u.d, \
                                        (unsigned) 1, \
                                        (unsigned) 10000000) 

#define MAX_DATA_PKTS_REPLACED  10

void fr_space();

/******************************************
  Variation of component structure for nodes
*/

caddr_t node_action();



typedef struct _Nodee {
  struct _Nodee
		*nd_next, *nd_prev; /* Links to other components in the list */
  short		nd_class;	/* = OTHER_CLASS */
  short		nd_type;	/* =NODE */
  char		nd_name[40];	/* Name of component (appears on screen) */
  PFP		nd_action;	/* Main function of component */
  COMP_OBJECT	nd_picture;	/* Graphics object that displays this thing */
  list		*nd_neighbors;	/* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */
  short		nd_menu_up;	/* If true, then the text window is up */
  queue		*nd_params;	/* Variable-length queue of parameters */
  Param		*nd_pktlog;	/* Turn packet logging on & off */
  /* Pointers into the queue of parameters for quick reference */
  Param		*nd_delay;	/* USECS it takes to process a packet */
  Param		*nd_speed;	/* USECS per Kbyte of data */
  Param		*nd_buffer_space; /* Max node buffer space (in bytes) */
  				/* (-1 ==> infinite memory) */
  Param		*nd_curr_buffer_space;
                                /* Current occupied node buffer space */
  Param		*max_occupied_space; /* Max occupied buffer space */
  Param		*nd_pq;		/* Input packet queue for received routing */   
				/* packets */
  Param		*nd_status;	/* State of node : up  or down */
  Param		*nd_dropped;	/* Number of data packets dropped */
  Param		*nd_time_btw_fails; /* Avg time between failures in secs */
  Param		*nd_time_for_repair; /* Time for repair in secs */
  Param         *dist_chosen_fail;   /* Parameters to indicate what
                                        distribution to use for times btw
                                        failures and repairs */
  Param		*dist_chosen_repair;
  Param         *sd_fail;               /* Standard deviations for unif dist */
  Param		*sd_repair;
  Param		*memory_utl;		/* Memory utilization */
  Param		*drop_rate;             /* Instantaneous drop rate */
  int   	last_packets_dropped;	/* Used to compute instantaneous */
					/* drop rate			 */
  LocalTopologyTable	loc_topology_table;
  RoutingTable		*nd_ptr_route_tab;  /* Pointer to routing info. table */
  PFI           	nd_route_process_time;  /* Pointer to  func returning */
                                             /* estimate of routing proc time */
  Routet		*nd_ptr_routing_mod; /* Pointer to the routing module */
 
  /* The following are used in trying make room to a routing packet
     when the node is full by dropping data packet(s) (used in function
     exist_data_space_to_replace()) */
  q_elt		*data_elt[MAX_DATA_PKTS_REPLACED];
  Neighbor	*which_queue[MAX_DATA_PKTS_REPLACED];
  q_elt		*prev_data_elt[MAX_DATA_PKTS_REPLACED];
  int 		TransmissionTime[MAX_DATA_PKTS_REPLACED];

} Nodee;
#endif	/* NODE_H */
  



