/* $Id: packet.h,v 10.1 92/10/06 23:08:50 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef PACKET_H
#define PACKET_H


#include "sim.h"
#include "component.h"


/* Packet types seen by a node or a link */
#define TR_PACKET	0
#define ROUTE_PACKET	1

/* Packet sub-types for application/transport module */
#define TR_DATA		0
#define TR_ACK		1
#define TR_TOKEN	2

/* Packet sub-types for routing packets */
#define RT_LINK_SHUTDOWN	0
#define RT_LINK_WAKEUP		1
#define RT_NODE_SHUTDOWN	2
#define RT_NODE_WAKEUP		3
#define RT_LS			4 /* spf */
#define RT_MSG			5 /* merlin segal 79 */ 
#define RT_REQ			6 /* merlin segal 79 */ 
#define RT_VECTOR		7 /* exBF 89 */
#define RT_VECTOR_ACK		8 /* exBF 89 */

/* Packet size definitions */
#define ACK_PKT_SIZE		32
#define TOKEN_PKT_SIZE		32
#define REQ_PKT_SIZE		16
#define MSG_PKT_SIZE		20
#define LS_PKT_HEADER_SIZE	16
#define VECTOR_PKT_HEADER_SIZE	24

/* Definition of a packet.
   The first part of the packet structure includes all information
   needed by the simulator itself and layers below.
*/

typedef struct _Socket {
  Component *so_port, *so_host;
} Socket;

typedef struct _APTR_Packet {	/* transport protocol part of packet */
  int	tr_type;
  int	response;
  int	data_size;
} APTR_Packet;

typedef struct {
   Component	*destination;	/* Destination node */
   unsigned int	best_cost;	/* Best cost from my node to destination */
   Component	*head;		/* Head of the current best path to */
                                /* destination */
} rt_vector_triplet;	/* Used by Extended BF */

/* Routing vector packet used by Extended BF */
typedef struct {
   Component		*sender;	/* Sender node */
   int			no_of_triplets;	/* no of entries in routing vector */

   int			failure_flag;	/* indicates whether a topological
					   change triggered the updates */
   Component		*node1;		/* event identity : nodes at both
					   ends of the failed link */
   Component		*node2;

} RT_VECTOR_Packet;

typedef struct {
   Component	*sink;
   Component	*sender;
   int		cycle_no;
   unsigned int	d;
} RT_MSG_Packet;

typedef struct {
   Component	*sink;
   Component	*sender;
   int		cycle_no;
} RT_REQ_Packet;

typedef struct {
   Component 	*neighbour;
   unsigned int cost;
} CostPair;

typedef struct  {		/* LS routing packet */
   Component 	*node;
   unsigned int seq_no;
   int	     	no_pairs;
} RT_LS_Packet;

typedef struct _RT_Packet {	/* routing module part of a packet */
  int		rt_type;
  union {
     RT_LS_Packet 	ls;
     RT_MSG_Packet	msg;
     RT_REQ_Packet	req;
     RT_VECTOR_Packet	vector;
  } rt;
} RT_Packet;

/***************************************************************
  Main packet structure.
*/

typedef struct _Packet {
  /* Pointer for use by the queue these things are stored in. */
  struct _Packet *pk_next;

  /* Ultimate source & destination.  Like sockets in TCP. */
  Socket pk_source_socket, pk_dest_socket;

  /* The component that this is going to. */
  Component *pk_next_comp;

  /* Length in bytes.  Note that this length has nothing to do with the
     length of this struture.  It is the length of the imaginary packet that
     is being sent.  */
  int pk_length;

  unsigned int pk_time;		/* Usually departure time */
  unsigned int pk_arrival_time;

  unsigned int pk_sent_time;    /* Used to compute the average delay of */
                                /* a packet from the time it was sent   */
                                /* to the time it was acked             */

  int pk_color;			/* Color assigned to packet */

  unsigned pk_uid;

  unsigned pk_type;		/* type of packet like : data, routing, etc */

  char     *tail;		/* other information can be following */

  APTR_Packet tr_pk;            /* transport protocol part of packet */
  RT_Packet   rt_pk;		/* routing part of packet */

} Packet;


void pk_free(), pk_free_all();
Packet *pk_alloc();
#endif   /* PACKET_H   */
