/* $Id: perf.h,v 10.1 92/10/06 23:08:53 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef PERF_MON_H
#define PERF_MON_H

#include "sim.h"
#include "q.h"
#include "list.h"
#include "simx1.h"		

void pm();

#define EV_PERF_UPDATE      	(EV_CLASS_PRIVATE | 1)

#define NEW_COMPONENT 		0  /* requests from performance monitor */
#define LINK_FAILURE		1
#define LINK_WAKEUP		2
#define CONN_UP			3
#define CONN_DOWN		4
#define NET_UTIL                5
#define ACK_RECEIVED            6
#define PKT_RETRANSMITTED       7
#define ROUTING_PKT       	8

typedef struct _LinkList {
   struct _LinkList 
      *next;
   Component	*comp;
} LinkList;

typedef struct _Pmt {
  struct _Pmt
		*pm_next, *pm_prev; /* Links to other PERF_MONs in the list */
  short		pm_class;	/* Class of PERF_MON */
  short		pm_type;	/* Type of PERF_MON that I am. */
  char		pm_name[40];	/* Name of PERF_MON (appears on screen) */
  PFP		pm_action;	/* Main function of PERF_MON.
				   Is called with each event that happens.
				   Syntax:  Many arguments needed.  */
  COMP_OBJECT	pm_picture;	/* Graphics object that displays this thing */

  /* Doubly linked list of neighbors.  Data stored for each
     neighbor includes a PARAM structure, and possibly some other stuff.
     The graphics routines will have to follow this list if they are going
     to display any data associated with individual neighbors.  */
  list		*pm_neighbors;

  /* Parameters-- data that will be displayed on screen */
  /* The number of parameters is fixed for each type of PERF_MON. */
  short		pm_menu_up;	/* If true, then the text window is up */
  queue		*pm_params;	/* Variable-length queue of parameters */

  Param		*TNT;		/* Total Network Throughput */
  Param		*ITNT;		/* Instantaneous Total Network Throughput */
  Param         *ITNT_SD;       /* standard dev of instantaneous thruput */
  Param		*AvgDelay;	/* Average delay per packet system wide */
  Param		*MaxDelay;	/* Max delay system wide */
  Param		*InstDelay;	/* Average delay per packet system wide */
  Param         *InstDelay_SD;  /* standard dev of instantaneous delay */
  Param		*LinkFailCnt;	/* Link failure count */
  Param		*PktDropped;	/* no packets dropped in the network */
  Param		*RoutingPkts;	/* no of routing packets in the network */
  Param         *DataLoad;      /* Data and Ack Load */
  Param         *IDataLoad;     /* Instantaneous Data and Ack Load */
  Param         *DataLoadSD;    /* Standard deviation of data and ack load*/
  Param         *RoutLoad;      /* Routing Load */
  Param         *IRoutLoad;     /* Instantaneous Routing Load */
  Param         *RoutLoadSD;    /* Standard deviation of routing load*/

  /* The following are statistics for the selected connections */
  Param         *sTNT;          /* Total Network Throughput */
  Param         *sITNT;         /* Instantaneous Total Network Throughput */
  Param         *sITNT_SD;       /* standard dev of instantaneous thruput */
  Param         *sAvgDelay;     /* Average delay per packet system wide */
  Param         *sMaxDelay;     /* Max delay system wide */
  Param         *sInstDelay;    /* Average delay per packet system wide */
  Param         *sInstDelay_SD;  /* standard dev of instantaneous delay */
  Param 	*sConnCnt;
  Param         *sPktDropped;   /* no packets dropped in the network */
  /* Following are for TNT, AvgDelay etc */
  double        stot_bytes_acked, /* double o/w it overflows */
                stot_delay,
                srecent_delay;
  int           stot_pkts_acked;
  /* The following are used to compute ITNT and InstDelay */
  int           srecent_pkts_acked;
  int           srecent_bytes_acked;
  /* The following to compute standard dev of ITNT */
  int           sITNT_pnt;      /* number of collected points */
  double        ssX;             /* sum of values */
  double        ssX2;            /* sum of squares of values */
  /* The following to compute standard dev of InstDelay */
  double        ssY;             /* sum of values */
  double        ssY2;            /* sum of squares of values */
  /* The above are statistics for the selected connections */

  
  /* Following are for TNT, AvgDelay etc */
  double	tot_bytes_acked, /* double o/w it overflows */
                tot_delay, 
                recent_delay;
  int           tot_pkts_acked;

  /* The following are used to compute ITNT and InstDelay */
  int           recent_pkts_acked;
  int           recent_bytes_acked;

  /* The following to compute standard dev of ITNT */
  int		ITNT_pnt;	/* number of collected points */
  double        sX;             /* sum of values */
  double        sX2;            /* sum of squares of values */

  /* The following to compute standard dev of InstDelay */
  double        sY;             /* sum of values */
  double        sY2;            /* sum of squares of values */

  /* The following parameters are used to compute the standard deviation
     of RoutLoad and of DataLoad */
  LinkList      *netlinkl;      /* list of the link components */
  int           Pnt;            /* no of sampling points */
  double        DatasX;         /* sum of data values */
  double        DatasX2;        /* sum of square of data values */
  double        RoutsX;         /* sum of rout values */
  double        RoutsX2;        /* sum of square of rout values */

  /* The following are used to compute max, min, and average "max occupied
     buffer space"  for all nodes in the network */
  Param 	*max_buffer_space;
  Param		*min_buffer_space;
  Param 	*ave_buffer_space;
  int		sum_buffer_space;
  int		total_no_of_nodes;

/* Connection statistics */
  Param		*ConnCnt;			/* Connection count */
  Param		*FTP_avg_conn_size;             /* ave # pkts per conn */
  Param		*FTP_avg_conn_duration;         /* ave time of conn */
  Param		*FTP_avg_conn_size_SD;    
  Param		*FTP_avg_conn_duration_SD;
  Param		*TELNET_avg_conn_size;       
  Param		*TELNET_avg_conn_duration;   
  Param		*TELNET_avg_conn_size_SD;    
  Param		*TELNET_avg_conn_duration_SD;
  double	FTP_ConnTotSize,
                FTP_ConnTotDuration,
                FTP_ConnTotSize2,
                FTP_ConnTotDuration2;
  int		FTP_ConnTotCnt;
  double	TELNET_ConnTotSize,
                TELNET_ConnTotDuration,
                TELNET_ConnTotSize2,
                TELNET_ConnTotDuration2;
  int		TELNET_ConnTotCnt;

} Pmt;

#endif PERF_MON_H

