/* $Id: route.h,v 10.1 92/10/06 23:08:56 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef ROUTE_H
#define ROUTE_H
/*
 * Routing Module Data Structures : Common Parts Between Algorithms
 * 
 */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"	
#include "lcostfcn.h"

unsigned int link_cost();
char	*make_ltt_text();
char	*make_rt_text();
void 	free_routing_queue();
void 	schedule_next_EV_ROUTE_PROCESSING();
int 	index_at_LTT_by_link(), index_at_LTT_by_node();
void	compute_link_cost_metrics();
void 	link_repair_init_LTT(), link_failure_init_LTT();

#define MAX_NO_OF_NODES		35
#define MAX_LINKS_PER_NODE	10
#define MAX_LINKS	 	MAX_LINKS_PER_NODE
#define INFINITY     		999999999

#define RT(g)  (*((RoutingTable *)(g->routing_table->u.p)))
#define LTT(g) (*((LocalTopologyTable *)(g->local_top->u.p)))

#define time_btw_broadcast(g) (random_no(1, \
					(double) g->brdcast_period->u.i,\
					(double) g->sd->u.i, \
					(unsigned) 1, \
					(unsigned) 10000000)*1000)


typedef struct {
	Component	*n_nd;		/* Pointer to the neighbor node */
	Component	*n_link;	/* Pointer to the outgoing link */
	int 		l_delay;	/* Propagation delay for link */
	int 		l_bandwidth;	/* Bandwidth for outgoing link */
	int 		queue_size;     /* no of bytes in the queue */
	int		last_op_time;   /* time at which last add/del is done */
	int	        avg_queue_size;  /* avg no of bytes in the queue */
	double          tot_queue_size;  /* used to compute avg_queue_size */
	queue		*l_q;		/* Pointer to queue of that link */
/* Following is maintained by the routing/naming module */
	char 		*l_status;	/* status of link */
	int 		l_cost;		/* cost of link */

	double		last_utilization; /* hop normalized delay */
	int		hndly_cost;
	double		total_trans_queuing_delay;
	double		total_tr_delay;
/* Following for delay cost function */
	double		total_delay;
	int		no_of_packets;
	double		ave_delay;
	int		delay_cost;
/* Following for utilization */
	int		total_util;
	double		ave_util;
	int		util_cost;
} LocalTopologyTable[MAX_LINKS_PER_NODE];  

typedef struct {
   Component  	*dest;
   Component  	*hop;
   unsigned int	cost;
} RoutingTable[MAX_NO_OF_NODES];

/*
 * Variation of component structure for route
 */
typedef struct _Routet {
/* The following are common to all components */
  struct _Routet *route_next,	    /* Links to other components in the list */
                *route_prev;

  short         route_class;	    /*  */
  short		route_type;	    /*  */
  char		route_name[40];	    /* Name of component (appears on screen) */
  PFP		route_action;  	    /* Main function of component.  */
  COMP_OBJECT	route_picture;	    /* Graphics object displays this thing */
  list		*route_neighbors;   /* List of neighbors of this thing */

  short		route_menu_up;	    /* If true, then the text window is up */
  queue		*route_params;	    /* Variable-length queue of parameters */

/* the following is common to all routing components */
  PFI		processing_time;    /* returns an estimate of proc time */
  int		no_of_nodes;	    /* seen no of nodes in the net */
  tick_t	link_cost_time;	    /* time at which link costs are calculated*/
  Component	*node;		    /* my neighbour node */

  Param		*routing_table;	    /* routing table */
  Param		*local_top;	    /* local topology table */

/* other specific algorithm dependent parameters follows */

} Routet;
#endif   /* ROUTE_H */
