/* $Id: segal.h,v 10.1 92/10/06 23:08:57 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef SEGAL_H
#define SEGAL_H
/*
 * Routing Module Data Structures for Merlin and Segall Algorithm
 * 
 */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"
#include "route.h"

#define EV_START_COMPUTATION	   	(EV_CLASS_PRIVATE | 1)

#define READY	2 	/* Link status */

caddr_t segal_action();

typedef struct {
   Component	*dest;	        	/* Pointer to node sink */
   unsigned int	cost;	        	/* Estimated cost to node sink */
   Component	*hop;			/* Pointer to preferred neighbour node */
                                           
   int		cycle_no;        	/* Current cycle number */
   int 		max_no;		        /* largest cycle number received */

   int		state;

   unsigned int	cost_via[MAX_LINKS];	/* Estimated cost thru neighbour nodes */
   int 		last_no_via[MAX_LINKS]; /* Last number received from neighbour */

   char		link_status[MAX_LINKS];/* Status of outgoing links */
   int		open_after[MAX_LINKS];	/* link is open after this cycle no */

   int		lastreqno;		/* Last request number sent */
   Component	*prev_hop;		/* ptr to last preferred neighbour */

} InfoTable[MAX_NO_OF_NODES];

typedef struct _Segalt {
  struct _Segalt *segal_next,	    /* Links to other components in the list */
                *segal_prev;

  short         segal_class;	    /*  */
  short		segal_type;	    /*  */
  char		segal_name[40];	    /* Name of component (appears on screen) */
  PFP		segal_action;  	    /* Main function of component.  */
  COMP_OBJECT	segal_picture;	    /* Graphics object displays this thing */
  list		*segal_neighbors;   /* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */

  short		segal_menu_up;	    /* If true, then the text window is up */
  queue		*segal_params;	    /* Variable-length queue of parameters */

  PFI		processing_time;    /* returns an estimate of proc time */
  int		no_of_nodes;	    /* seen no of nodes in the net */
  tick_t	link_cost_time;	    /* time at which link costs are calculated*/
  Component	*node;		    /* my neighbour node */

  Param		*routing_table;	    /* routing table */
  Param		*local_top;	    /* local topology table */
  Param		*info_table;        /* Information table */   
  Param		*brdcast_period;    /* time btw start events */
  Param		*sd;    	    /* deviation */
} Segalt;
#endif   /* SEGAL_H */
