#ifndef SIM_H
#define SIM_H
 /* $Id: sim.h,v 10.1 92/10/06 23:08:59 ca Exp $ */

#include <sys/types.h>
#include <strings.h>
#include <stdio.h>
#include <math.h>

/* Things for all simulator routines */

#define TRUE 1
#define FALSE 0
#ifndef NULL
#  define NULL 0
#endif  /* not NULL */
#define OFF 0
#define ON 1
#define ERROR -1
#define OK 1

#define DEFAULT_PERF_UPDATE_DT_USECS 	25000

#ifdef OFFLINE
#define DEFAULT_SKIP_TIME_IN_TICKS	10000000
#else
#define DEFAULT_SKIP_TIME_IN_TICKS	0
#endif

extern unsigned long int perf_update_dt_usecs;
extern unsigned long int skip_time_in_ticks;

typedef unsigned int tick_t;
extern int  record_flag;
extern int  play_flag;
extern int  profile_flag;
extern char playfilename[];
extern FILE *record_file;
extern FILE *profilefile;

/* Define time elapsed per simulator clock tick either in USECS_PER_TICK 
   or NSECS_PER_TICK.  Either USECS_PER_TICK or NSECS_PER_TICK should be
   defined, but not both.
   NSECS_PER_TICK must divide 1000 or else you will get some strange
   roundoff errors. */

#define USECS_PER_TICK		10

#ifdef NSECS_PER_TICK
# define  NSECS_TO_TICKS(time) ((tick_t)  ((time) / NSECS_PER_TICK) )
# define  TICKS_TO_NSECS(ticks) ((ticks) * NSECS_PER_TICK)
# define  USECS_TO_TICKS(time) ((tick_t) ((time) * (1000 / NSECS_PER_TICK)) )
# define  TICKS_TO_USECS(ticks) ((ticks) / (1000 / NSECS_PER_TICK))
# define  SECSD_TO_TICKS(time) ((tick_t) (((time) * 1000000000) / NSECS_PER_TICK))
# define  TICKS_TO_SECSD(ticks) ((((double) (ticks)) * NSECS_PER_TICK) / 1000000000)
#else
# ifdef USECS_PER_TICK
#  define NSECS_TO_TICKS(time) ((tick_t) ((time) / (USECS_PER_TICK * 1000)))
#  define TICKS_TO_NSECS(ticks)  ((ticks) * (USECS_PER_TICK * 1000))
#  define USECS_TO_TICKS(time) ((tick_t) ((time) / USECS_PER_TICK))
#  define TICKS_TO_USECS(ticks)  ((ticks) * USECS_PER_TICK)
#  define MSECS_TO_TICKS(time) ((tick_t) (((time) * 1000) / USECS_PER_TICK))
#  define TICKS_TO_MSECS(ticks) ((((double) (ticks)) * USECS_PER_TICK) / 1000)
#  define SECSD_TO_TICKS(time) ((tick_t) (((time) * 1000000) / USECS_PER_TICK))
#  define TICKS_TO_SECSD(ticks) ((((double) (ticks)) * USECS_PER_TICK) / 1000000)
# endif
#endif


#define UNIX_4_2    1
#define UNIX_4_3    2
#define SLOW_START  3


#define DBG_INFO	1
#define DBG_ERR		2

#ifdef __STDC__
extern double   atof( const char *__nptr );
#define CONST const
#else  /* __STDC__ */
double atof();
#define CONST
#endif  /* __STDC__ */

extern char *strncpy(), *strcpy(), *strcat(), *strncat();
extern char *calloc(), *malloc(), *realloc();
char *sim_calloc(), *sim_malloc(), *sim_realloc();
void panic();

/** Largest number returned by random(). (2**31)-1   From RANDOM(3) */
#define MAX_RANDOM_NUMBER 2147483647
extern long random();
double random_range();

#define min(a, b)  ((a) < (b) ? (a) : (b))
#define max(a, b)  ((a) > (b) ? (a) : (b))
/* Some source uses upper, some lower. */
#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#define MIN(a, b)  ((a) < (b) ? (a) : (b))

/* Oft-used item:  Pointer to a Function that returns an Integer */
typedef int (*PFI)();
/* Pointer to Function that returns a Double.  */
typedef double (*PFD)();
/* Pointer to Function that returns a Pointer */
typedef caddr_t (*PFP)();

#endif   /* SIM_H   */
