/* $Id: simple_traffic.h,v 10.1 92/10/06 23:09:00 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef SMPLTRFC_H
#define SMPLTRFC_H
   /*
    * Application Transport Module
    * 
    */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"
   
#define EV_APTR_PRODUCE      (EV_CLASS_PRIVATE | 1)

caddr_t SmplTrfc_source_action();
caddr_t SmplTrfc_sink_action();

/*
 * Variation of component structure for SmplTrfc
 */
typedef struct _SmplTrfct {
   struct _SmplTrfct *co_next,	    /* Links to other components in the list */
                    *co_prev;
   
   short        class;	    	
   short	type;	    	
   char		name[40];	/* Name of component (appears on screen) */
   PFP		action;		/* Main function of component.  */
   COMP_OBJECT	picture;	/* Graphics object displays this thing */
   list		*neighbors;	/* List of neighbors of this thing */
   
   /* Parameters-- data that will be displayed on screen */
   
   short	menu_up;	/* If true, then the text window is up */
   queue	*params;	/* Variable-length queue of parameters */
   
   Socket	source_socket;	/* (host aptr) of source */
   Socket	dest_socket;	/* (host aptr) of destination */
   Param	*peer;		/* (host.name aptr.name) of dest */
   Param	*simple_select;	/* Indicates whether conn selected */

   Param	*window_size;   /* send window size */
   Param	*packets_sent;	/* no of data packets send */
   Param	*packets_acked;	/* no of data packets acked */
   Param	*packets_recvd;	/* no of data packets received */
   Param	*packets_dropped;/* no of datapackets retransmitted */
   
   Param	*packet_length;	/* packet size */
   Param	*packet_delay;	/* usecs between cars */
   Param	*dist_chosen;
   Param 	*sd;
   
   int		last_pkt_delay;	/* needed by perf mon */
   int		data_acked;	/* needed by perf mon */
   int          last_bytes_acked;
} SmplTrfct;
#endif   /* SMPLTRFC_H */

