/* $Id: spf.h,v 10.1 92/10/06 23:09:08 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef SPF_H
#define SPF_H
/*
 * Routing Module Data Structures
 * 
 */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"
#include "route.h"

#define EV_SPF_BROADCAST   	(EV_CLASS_PRIVATE | 1)
#define GTT(g) (*((GlobalTopTable *)(g->global_top->u.p)))

caddr_t spf_action();

typedef struct {
   Component 	*dest;
   int 	     	no;
   int 	     	no_unprocessed;
   char	      	mark;
} SeqNoTable[MAX_NO_OF_NODES];

typedef unsigned int GlobalTopTable[MAX_NO_OF_NODES][MAX_NO_OF_NODES];

/*
 * Variation of component structure for spf route
 */
typedef struct _Spft {
  struct _Spft *spf_next,	    /* Links to other components in the list */
                *spf_prev;

  short         spf_class;	    /*  */
  short		spf_type;	    /*  */
  char		spf_name[40];	    /* Name of component (appears on screen) */
  PFP		spf_action;  	    /* Main function of component.  */
  COMP_OBJECT	spf_picture;	    /* Graphics object displays this thing */
  list		*spf_neighbors;   /* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */

  short		spf_menu_up;	    /* If true, then the text window is up */
  queue		*spf_params;	    /* Variable-length queue of parameters */

  PFI		processing_time;    /* returns an estimate of proc time */
  int		no_of_nodes;	    /* seen no of nodes in the net */
  tick_t	link_cost_time;	    /* time at which link costs are calculated*/
  Component	*node;		    /* my neighbour node */

  Param		*routing_table;	    /* routing table */
  Param		*local_top;	    /* local topology table */
  Param		*global_top;	    /* global topology table */
  Param		*seq_no_table;	    /* last sequence no of a node */
  Param		*brdcast_period;    /* time btw broadcast events */
  Param		*sd;
  Param		*seq_no;	    /* sequence no of this node */   

} Spft;
#endif   /* SPF_H */
