/* $Id: telnet.h,v 10.1 92/10/06 23:09:12 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#ifndef TELNET_H
#define TELNET_H
/*
 * Application Transport Module with Telnet traffic
 * 
 */
#include "sim.h"
#include "q.h"
#include "list.h"
#include "component.h"

#define EV_APTR_PRODUCE      (EV_CLASS_PRIVATE | 1)
#define EV_APTR_CONSUME      (EV_CLASS_PRIVATE | 2)
#define EV_APTR_SEND         (EV_CLASS_PRIVATE | 3)

caddr_t telnet_source_action();
caddr_t telnet_sink_action();

/*
 * Variation of component structure for telnet
 */
typedef struct _Telnett {
  struct _Telnett *telnet_next,	    /* Links to other components in the list */
                *telnet_prev;

  short         telnet_class;	    /*  */
  short		telnet_type;	    /*  */
  char		telnet_name[40];    /* Name of component (appears on screen) */
  PFP		telnet_action;      /* Main function of component.  */
  COMP_OBJECT	telnet_picture;	    /* Graphics object displays this thing */
  list		*telnet_neighbors;  /* List of neighbors of this thing */

  /* Parameters-- data that will be displayed on screen */

  short		telnet_menu_up;	    /* If true, then the text window is up */
  queue		*telnet_params;	    /* Variable-length queue of parameters */

  Socket	source_socket;	    /* (host aptr) of source */
  Socket	dest_socket;        /* (host aptr) of destination */
  Param		*telnet_peer;	    /* (host.name aptr.name) of dest */
  
  Param		*telnet_select;	    /* Flag to determine whether selected */

  Param		*telnet_produce_ws; /* produce window size */
  Param		*telnet_send_ws;    /* send window size */

  Param		*telnet_packets_produced;  /* no of data packets produced */
  Param		*telnet_packets_sent;	   /* no of data packets send */
  Param		*telnet_packets_acked;	   /* no of data packets acked */
  Param		*telnet_packets_recvd;	   /* no of data packets received */
  Param		*telnet_packets_retransmitted; /* no of datapackets retransmitted */
  int		telnet_token_time;	   /* time when the token last sent */
  Param		*telnet_rtt;		   /* round trip time estimate */

  Param		*telnet_tr_delay;	   /* integer; usecs between trains */
  Param		*telnet_tr_how_many;	   /* Number of trains  */
  Param		*telnet_car_how_many;	   /* Number of cars in this train  */
  Param		*telnet_car_per_tr;	   /* Number of cars per train  */
  Param		*telnet_car_delay;	   /* integer; usecs between cars */
  Param		*telnet_car_length;	   /* integer; packet size */
  Param		*telnet_response_delay;    /* integer; response delay */
  Param		*telnet_response_length;   /* integer; response packet size */
  Param         *telnet_current_train;	   /* Number of the train being sent */
  Param         *telnet_current_car;	   /* Number of the car being sent */
  Param		*dist_chosen;              /* Distribution chosen for tr_delay, car_delay
                                              and response_delay */
  Param 	*sd_conn;                  /* Standard deviation for tr_delay */
  Param 	*sd_packet;                /* Standard deviation for car_delay */
  Param 	*sd_response;              /* Standard deviation for response_delay */

  Param		*init_conn_on_off;         /* Whether the first connection is on/off */
  Param		*conn_on_off;		   /* Whether connection is on/off */
  int         	conn_start_time;
  int		no_of_current_conns;       /* Useful only if end of the previous 
					      train overlaps with the next train */
  int		no_of_total_cars;

  Param         *sent_thruput;           
  Param         *acked_thruput;

  Param         *inst_delay;               /* Inst delay of a packet from    */
                                           /* the time it was sent to the    */
                                           /* time it was acked              */
  Param         *retransmission_rate;

  int           telnet_bytes_sent;         /* Used to compute instantaneous   */
  int           total_prev_bytes_acked;    /* sent, acked, and retrans. rates */
  int           telnet_bytes_retransmitted; 

  int           total_delay;		   /* Used to compute inst delay for */
  int		recent_pkts_acked;	   /* this connection */

  int		last_pkt_delay;	           /* needed by perf mon */
  int		data_acked;		   /* amount of data acked in bytes */
  int		last_bytes_acked;

  int 		produce_scheduled;	 
} Telnett;
#endif   /* TELNET_H */


