/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef COMP_TRANS_H
#define COMP_TRANS_H
#include <Xm/Xm.h>
#include "xm-network.h"
#include "xm-info_w.h"

void move_window(Widget,XButtonEvent *,String *,int *);
void raise_window(Widget,XButtonEvent *,String *,int *);
void lower_window(Widget,XButtonEvent *,String *,int *);

void move_component(Widget w,XButtonEvent *event,String *args, int *num_args);
void raise_component(Widget,XButtonEvent *,String *,int *);
void lower_component(Widget,XButtonEvent *,String *,int *);

void join_components(Widget w,XButtonEvent *event,String *args, int *num_args);
void select_component(Widget w,XButtonEvent *event,String *args, int *num_args);
void open_group(Widget w,XButtonEvent *event,String *args, int *num_args);
void close_group(Widget w,XButtonEvent *event,String *args, int *num_args);
void rubberbox(Widget w, XButtonEvent *event, String *argv, int *argc);
void make_peer(Widget w, XButtonEvent *event, String *argv, int *argc);

int get_relationship(MComponent *comp1, MComponent *comp2);
void disconnect_two_components(MComponent *comp1, MComponent *comp2);
void connect_two_components(MComponent *comp1, MComponent *comp2);

#endif




