/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef ICON_H
#define ICON_H

#include <Xm/Xm.h>
#include "xm-network.h"

void GetIconDimensions(Widget icon, int *return_w, int *return_h);
void TranslateIconCoords(Widget icon, Position x, Position y, Position *rel_x, Position *rel_y);

void SelectComponentIcon(MComponent *comp);
void UnselectComponentIcon(MComponent *comp);
void ChangeComponentIconName(MComponent *comp, char *new_name);

Widget CreateIcon(Widget parent, char *name, int type, int *x, int *y);
void DestroyIcon(Widget icon);
void DrawIcon(Widget icon);
void EraseIcon(Widget icon);
void MoveIcon(Widget icon, int *new_x, int *new_y);

#endif
