/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef INFO_W_H
#define INFO_W_H

#include <Xm/Xm.h>
#include "xm-network.h"

#define HIDE_CHILDREN 0x0001
#define HIDE_METERS 0x0002
#define HIDE_NONE 0x0000

/*--------------------------------------------------------------------------------------------------------------------------------*/
typedef struct {        /* Common to all information window data. */
  MComponent *comp;
  Widget dialog_widget;
} InfoWinData;

/*--------------------------------------------------------------------------------------------------------------------------------*/
void OpenComponentInformationWindow(MComponent *comp, int given_x, int given_y, int valid_coords);
void CloseComponentInformationWindow(MComponent *comp);


void OpenGroupInformationWindow(MComponent *comp, int given_x, int given_y, int valid_coords);
void CloseGroupInformationWindow(MComponent *comp);

void CloseInformationWindow(MComponent *comp);

void open_info_w_tn(Widget,XEvent *,String *,int *);
void close_info_w_tn(Widget,XEvent *,String *,int *);
void open_close_info_w_tn(Widget,XEvent *,String *,int *);

void SetGroupOpenCloseButton(MComponent *group);

void SaveVisibility(MComponent *comp);
void RestoreVisibility(MComponent *comp);

void MakeChildrenInvisible(MComponent *comp);
void MakeChildrenVisible(MComponent *comp);
void MakeMetersInvisible(MComponent *comp);
void MakeMetersVisible(MComponent *comp);

#endif









