/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef LINES_H
#define LINES_H
#include <X11/Xlib.h>
#include "xm-network.h"

typedef struct {
   MComponent *comp1,*comp2;
} ComponentPair;

typedef struct {
   XSegment *line_array;
   ComponentPair *comp_pairs;
   int num_lines;
   int memory;
} SegmentList;

extern SegmentList *network_segmentlist;  /* The list of line segments between components. */

#define swap(c1,c2) {caddr_t tmp; tmp=c2;c2=c1;c1=tmp;}

SegmentList *create_segmentlist();
void destroy_segmentlist(SegmentList *sl);
int add_segment(SegmentList *sl, MComponent *comp1, MComponent *comp2);
int delete_segment(SegmentList *sl, MComponent *comp1, MComponent *comp2);
int find_segment(SegmentList *sl, MComponent *comp1, MComponent *comp2);
void draw_segments(SegmentList *sl, Display *display, Window window, GC gc);
void add_segments(SegmentList *sl, SegmentList *new_segments);
void delete_segments(SegmentList *sl, SegmentList *old_segments);

#endif
