/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef MAIN_W_H
#define MAIN_W_H

#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>

extern Widget scroll_w;
extern Widget main_w;
extern Widget clock_w;
extern Widget main_w_shell;
extern Widget network_w;
extern Widget message_w;
extern Widget meter_w;
extern Widget meter_w_shell;
extern Widget pause_button;
extern Widget start_button;

void redraw_lines(Widget network_w, XtPointer client_data, XmDrawingAreaCallbackStruct *cbs);
void BuildMainWindow();

#define NETWORK_STOPPED 1
#define NETWORK_RUNNING 2
#define NETWORK_PAUSED 3

extern int network_status;
extern int reset_components;  /* This is set whenever a component is killed. All components are reset
				 before returning to the main loop. */
#endif




