/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef NETWORK_H
#define NETWORK_H

#define POST_ORDER 0
#define PRE_ORDER 1

#include <Xm/Xm.h>
#include "simx.h"

#define ClearStatus(comp)              (comp)->status=0
#define SetStatusVisible(comp)         (comp)->status |= VISIBLE
#define SetStatusSelected(comp)        (comp)->status |= SELECTED
#define SetStatusGroupOpen(comp)       (comp)->status |= GROUP_OPEN
#define SetStatusDrawn(comp)           (comp)->status |= DRAWN
#define SetStatusInfoWindowOpen(comp)  (comp)->status |= INFO_WINDOW_OPEN
#define SetStatusParamWindowOpen(comp) (comp)->status |= PARAM_WINDOW_OPEN
#define SetStatusWasVisible(comp)      (comp)->status |= WAS_VISIBLE
#define SetStatusChildrenHidden(comp)    (comp)->status |= CHILDREN_HIDDEN
#define SetStatusMetersHidden(comp)      (comp)->status |= METERS_HIDDEN

#define SetStatusInvisible(comp)         (comp)->status &= ~VISIBLE
#define SetStatusUnselected(comp )       (comp)->status &= ~SELECTED
#define SetStatusGroupClosed(comp)       (comp)->status &= ~GROUP_OPEN
#define SetStatusUndrawn(comp)           (comp)->status &= ~DRAWN
#define SetStatusInfoWindowClosed(comp)  (comp)->status &= ~INFO_WINDOW_OPEN
#define SetStatusParamWindowClosed(comp) (comp)->status &= ~PARAM_WINDOW_OPEN
#define SetStatusWasNotVisible(comp)     (comp)->status &= ~WAS_VISIBLE
#define SetStatusChildrenNotHidden(comp) (comp)->status &= ~CHILDREN_HIDDEN
#define SetStatusMetersNotHidden(comp)   (comp)->status &= ~METERS_HIDDEN

extern MComponentList network_components;  /* The list of all network components. */
extern MComponentList selected;  /* The list of selected components. */

/*========================= Functions to access the component network data structure ==========================*/
int ParentType(MComponent *comp);        /* Returns the type of the parent component.  Components with no parent are considred members of 
					    the top level group, so they would return TYPE_GROUP. */
MComponent *GetGroup (MComponent *comp);  /* Returns the group containing the component. If the component is a group,
					     it returns the component's parent. */
void ChangeComponentName(MComponent *comp,char *new_name);

MComponent *GetComponentOfIcon(Widget icon);  /* Returns a pointer to the component associated with the icon. */

Widget InitializeNetwork(Widget parent);  /* Create the network window as a child of the parent.*/

int GroupMemberp(MComponent *comp, MComponent *group); /* Is the component a member of the group. */

MComponent *NewComponent(char *name, int type, int x, int y);  /* Create a new component and add it to the top level group of the
								  network data structure at position (x,y). */ 

void KillComponent(MComponent *comp);  /* Remove the component from the network and free its storage. If this is the last member of a group, 
					  then destroy the group. */

MComponent *NewGroup(char *name, MComponentList l); /* Create a new group and add the Components given in list.
						 note: All components on list must be direct children of the
						       same group.  */

void KillGroup(MComponent *group);  /* Kills all group members along with the group. */
void OpenGroup(MComponent *group);  /* Hide the group icon and display all components within a group. */
void CloseGroup(MComponent *group);  /* Hide all components within a group and display the group icon. */
void UnGroup(MComponent *group);    /* Kills just the group icon.  The members become children of the group's parent (which is also a group). */

void ConnectChild(MComponent *child, MComponent *parent);  /* Remove the component from the group's childlist it's currently on. 
                                                            Connect the component to the child list of parent.
                                                            The child should not have any sisters. */   

void DisconnectChild(MComponent *comp);  /* Remove the component from the childlist it's currently on.
					    Connect the component to the group containing the child's parent. */

void ConnectSisters(MComponent *sister1, MComponent *sister2);
void DisconnectSisters(MComponent *sister1, MComponent *sister2);
void DisconnectAllSisters(MComponent *comp); /* Disconnect the component from all it's sisters. */

void MoveComponent(MComponent *comp, int new_x, int new_y); /* Move the component to the new coordinates. */

void MakeInvisible(MComponent *comp);
void MakeVisible(MComponent *comp);

void TraverseNetworkWithArguments(int order,void (*func)(), void *args);
void TraverseNetwork(int order,void (*func)());

void UnselectComponent(MComponent *comp);
void SelectComponent(MComponent *comp);
void UnselectGroupMembers(MComponent *group);
     
#endif







