/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef PARAM_W_H
#define PARAM_W_H

#include "simx.h"
#include "xm-network.h"
#include "xm-info_w.h"

typedef struct {
  String initial_value;  /* To be restored if cancel is pushed. */
  String current_value;  
  PARAM *parameter;
  Widget textfield;  /* For input parameters this holds the new value to change to.
			For output parameters this textfield can be updated as the parameter value changes. */
  Widget meter_toggle;
  Widget log_toggle;
  int changed_by_user;
  int new_value_entered;
} ParameterTextfield;

typedef struct ParamWinData {
  MComponent *comp;
  Widget dialog_widget;
  int cancel_changes;
  ParameterTextfield **textfields;  /* An array of ParameterTextfield structures. */
  unsigned num_params;              /* The number of displayable parameters. */
} ParamWinData;

void open_param_w_tn(Widget w, XEvent *event, String *args, int *num_args);
void open_close_param_w_tn(Widget w, XEvent *event, String *args, int *num_args);
void close_param_w_tn(Widget w, XEvent *event, String *args, int *num_args);

void open_param_w_cb(Widget w, void *info_w_data, XmAnyCallbackStruct *cbs);
void change_parameter_cb(Widget w, ParamWinData *window_data, XmAnyCallbackStruct *cbs);
int restore_initial_parameter_value(ParameterTextfield *p_info, COMPONENT *scomponent);
void set_changed_by_user_flag(Widget w, ParamWinData *window_data, XmAnyCallbackStruct *cbs);
void destroy_parameter_cb(Widget w, ParamWinData *window_data, XmAnyCallbackStruct *cbs);

void OpenParameterWindow(MComponent *comp, int given_x, int given_y, int valid_coords);
void CloseParameterWindow(MComponent *comp);
void UpdateParameterWindow(MComponent *comp);

#endif




 




