/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#ifndef UTIL_H
#define UTIL_H

#include <Xm/Xm.h>

#define TEXT_INPUT_WIDTH 32

/*--------------------------------------------------------------------------------------------------------------------------------*/
typedef struct {
   Position x,y;
} CoordinatePair;

/*--------------------------------------------------------------------------------------------------------------------------------*/
typedef struct {
  char *label;
  void (*callback)();
  int set;
  XtPointer data;
} ToggleBoxItem;

/*=================================================== Main Menu Data Structure ============================================================*/
/* MenuItem and ActionAreaItem are modified versions of structures copied from the example programs listed in the following publication:

   The Definitive Guides to the X Window System: Volume 6, Motif Programming Manual by Dan Heller. O'Reilly & Associates, Inc. 1991.


   The following copyright notice applies only to the MenuItem and ActionAreaItem structures:    */

/* Written by Dan Heller.  Copyright 1991, O'Reilly && Associates.
 * This program is freely distributable without licensing fees and
 * is provided without guarantee or warrantee expressed or implied.
 * This program is -not- in the public domain.
 */

typedef struct _menu_item {
    char        *label;         /* the label for the item */
    WidgetClass *class;         /* pushbutton, label, separator... */
    char         mnemonic;      /* mnemonic; NULL if none */
    char        *accelerator;   /* accelerator; NULL if none */
    char        *accel_text;    /* to be converted to compound string */
    char        *callback_list;  /* name of list to add callback to */
    void       (*callback)();   /* routine to call; NULL if none */
    XtPointer    callback_data; /* client_data for callback() */
    struct _menu_item *subitems; /* pullright menu items, if not NULL */
    void (*creation_function)(); /* The widget is passed to this function, just after it is created. */  
} MenuItem;

typedef struct {
  char *label;
  void (*callback)();
  XtPointer data;
  void (*creation_function)();  /* passed (Widget w, XtPointer calldata) */
} ActionAreaItem;

/*--------------------------------------------------------------------------------------------------------------------------------*/
#define new_string(str) strcpy((char *)sim_malloc(strlen(str)+1),str)

#define remove_quotes(str) \
	   if ((str)[0]=='\'') {\
	      char *tmp;\
	      tmp=new_string(&(str)[1]);\
	      tmp[strlen(tmp)-1]='\0';\
	      strcpy(str,tmp);\
	      free(tmp);\
	   }

#define l_empty(l) ((l)->l_head==NULL)

#define WARNING(message) printf("Warning! %s\n",message)
#define TRACE(message) /*printf("%s\n",message)*/

#define GetWidgetCoordinates(w,x,y)  {Position px,py; XtVaGetValues(w,XmNx,&px,XmNy,&py,NULL); x=(int)px; y=(int)py;} 
#define SetWidgetCoordinates(w,x,y)  XtVaSetValues(w,XmNx,x,XmNy,y,NULL)
#define SetWidgetUserData(w,data)    XtVaSetValues(w,XmNuserData,data,NULL)
#define GetWidgetUserData(w,data)    XtVaGetValues(w,XmNuserData,&data,NULL)

#define SetWidgetTranslations(w,t) XtVaSetValues(w,XmNtranslations,XtParseTranslationTable(t),NULL)

#define SetLabelString(w,cstr) {XmString xstr=XmStringCreateSimple(cstr); XtVaSetValues(w,XmNlabelString,xstr,NULL); XmStringFree(xstr);}

#define CreateSeparator(parent,type,topwidget) XtVaCreateManagedWidget("", xmSeparatorGadgetClass, parent, \
								       XmNseparatorType, type, \
								       XmNleftAttachment, XmATTACH_FORM, \
								       XmNrightAttachment, XmATTACH_FORM, \
								       XmNtopAttachment, XmATTACH_WIDGET, \
								       XmNtopWidget, topwidget, \
								       NULL)
#define RaiseWidget(w) XRaiseWindow(XtDisplay(w), XtWindow(w))
#define LowerWidget(w) XLowerWindow(XtDisplay(w), XtWindow(w))

void SetShellPosition(Widget w, CoordinatePair *pos);

void WWTranslateCoords(Widget w1,Widget w2,Position w1x,Position w1y,Position *w2x,Position *w2y);
void RWTranslateCoords(Position x, Position y, Widget w, Position *wx, Position *wy);

int which_string(String key, String *strings, int nstrings);

Widget BuildPullDownMenu(Widget parent, char *menu_title, char *menu_mnemonic, MenuItem *items);

Widget CreateActionArea(Widget parent, ActionAreaItem *action, int num_actions, int default_button);
Widget CreateToggleBox(Widget parent, ToggleBoxItem *toggle_items, int num_items, int orientation, int num_columns);
Widget CreateTextInputField(Widget parent, char **input_list, char **initial_values,  Widget *textfields, int n);
Widget CreateTextInput(Widget parent, String prompt, String initial_value,  Widget *textfield);
      /* Build a form widget as  <prompt>: <initial value> */  

char *GetTypeName(int type);
int GetTypeNumber(char *type_name);

void ClearDefaultNumbers();
void SetDefaultNumber(char *type_name, int number);
char *GetNextDefaultName(char *type_name);
char *PeekNextDefaultName(char *type_name); /* Look at the next default name without changing it. */

#endif

















