/* $Id: comptypes.c,v 10.1 92/10/06 23:10:22 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#include "sim.h"
#include "comptypes.h"

/**********************************************************************
  The following array is used by the simulator to map the strings
  contained in the world file to component types (integers) and to
  the action routines used by each component.  The strings *must* be
  uppercase, and the strings in any world file must match the strings
  here exactly (except for case).  The integer component type is the
  index into the array of the component type name.  */

/* The following are array assignments of the form:
 <comp_type>_p[]={<parent_type_list>,-1}

The assignment means: Component's of type <comp_type> have parents which are
                      members of <parent_list>.  
For example, when an FTP_SOURCE is connected to a NODE, the FTP_SOURCE would
become a child of the NODE because `NODE' is in the parent list of FTP_SOURCE.

If a LINK were connected to a NODE, then the LINK would become a sister of the
NODE, because 'NODE' is not in the parent list of LINK. */

static int		   link_p[]={-1};
static int		   node_p[]={-1};
static int		    spf_p[]={NODE,-1};
static int		  segal_p[]={NODE,-1};
static int		   exbf_p[]={NODE,-1};
static int	       exbf_ack_p[]={NODE,-1};
static int	     ftp_source_p[]={NODE,-1};
static int	       ftp_sink_p[]={NODE,-1};
static int	  telnet_source_p[]={NODE,-1};
static int	    telnet_sink_p[]={NODE,-1};
static int	  simple_source_p[]={NODE,-1};
static int	    simple_sink_p[]={NODE,-1};
static int	       perf_mon_p[]={-1};
static int		stopper_p[]={-1};
static int  	 link_cost_func_p[]={-1};

Component_type component_types[] = {
	{"LINK",		LINK_CLASS,	link_action,		
	    link_p},
	{"NODE",		NODE_CLASS,	node_action,		
	    node_p},
	{"SPF",			ROUTE_CLASS,	spf_action,		
	    spf_p},
	{"SEGAL",		ROUTE_CLASS,	segal_action,		
	    segal_p},
	{"EXBF",		ROUTE_CLASS,	exBF_action,		
	    exbf_p},
	{"EXBF_ACK",		ROUTE_CLASS,	exBF_ack_action,	
	    exbf_ack_p},
	{"FTP_SOURCE",		APTR_CLASS,	ftp_source_action,	
	    ftp_source_p},
	{"FTP_SINK",		APTR_CLASS,	ftp_sink_action,	
	    ftp_sink_p},
	{"TELNET_SOURCE",	APTR_CLASS,	telnet_source_action,	
	    telnet_source_p},
	{"TELNET_SINK",		APTR_CLASS,	telnet_sink_action,	
	    telnet_sink_p},
	{"SIMPLE_SOURCE",	APTR_CLASS,	SmplTrfc_source_action,	
	    simple_source_p},
	{"SIMPLE_SINK",		APTR_CLASS,	SmplTrfc_sink_action,	
	    simple_sink_p},
	{"PERF_MON",		AUXILIARY_CLASS,pm_action,		
	    perf_mon_p},
	{"STOPPER",		AUXILIARY_CLASS,stopper_action,		
	    stopper_p},
	{"LINK_COST_FUNC",	AUXILIARY_CLASS,lcostfcn_action,	
	    link_cost_func_p},
	{"", NULL} /* This line indicates the end of the list.  */
};
