/* $Id: packet.c,v 10.1 92/10/06 23:10:36 ca Exp $ */

/** Routines for allocating and freeing packets.
    Very simple--just uses a mempool structure to keep track of them and to
    allow all of them to be freed with one stroke.  */

/** Includes:
 	pk_init()		Initialize the pool of packets.  Returns
				0 for failure.
	Packet *pk_alloc()	Allocates a packet and returns a pointer
				thereto.  The packet is guaranteed to contain
				garbage.
	void pk_free(pk)	Passed a packet pointer, frees it.
	void pk_free_all()	Frees *all* packets.
*/

#include <sys/types.h>
#include <stdio.h>
#include "sim.h"
#include "mempool.h"
#include "simx.h"
#include "packet.h"

static Mempool *pk_mempool = NULL;
static unsigned packet_uid = 0;
int packet_colors[64];
int num_packet_colors;
static int color_index;

pk_init()
{
  if (pk_mempool)
    {
      mp_free_all(pk_mempool);
      return(TRUE);
    }

  color_index = 0;
  pk_mempool = mp_init(100, sizeof(Packet));
  return(TRUE);
}


Packet *
pk_alloc()
{
  register Packet *pk = (Packet *)mp_alloc(pk_mempool);

  pk->pk_uid = packet_uid++;
  pk->tail   = NULL;

  pk->pk_color = color_index++;
  if (color_index >= num_packet_colors)
    color_index = 0;

  return(pk);
}

void
pk_free(pk)
     Packet *pk;
{

  if (pk->tail)
     free(pk->tail);

  mp_free(pk_mempool, (char *)pk);
}

void
pk_free_all()
{
  /* loop thru packets to free tail */

  mp_free_all(pk_mempool);
}

pk_stat()
{
  mp_stat(pk_mempool);
}
