/* $Id: peer.c,v 10.1 92/10/06 23:10:38 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#include <sys/types.h>
#include <stdio.h>
#include "sim.h"
#include "simx.h"
#include "meters.h"
#include "xtables.h"
#include "comptypes.h"
#include "eventdefs.h"
#include "list.h"
#include "component.h"
#include "peer.h"

list *peer_list = (list *) NULL;

#ifndef NoX
#ifndef MOTIF /* eric */
make_peer_event_handler(bevent)
     XButtonPressedEvent *bevent;
{
  static XCOMPONENT *last_xcomponent = NULL;
  NEIGHBOR *neighbor;
  PARAM *parameter;
  XCOMPONENT *present_xcomponent;
  caddr_t result_flag;
  int param_array_size1= 0, param_array_size2 = 0;
  int they_are_neigh;
 
  if (bevent->subwindow == 0)
    {
      last_xcomponent = NULL;
      return (-1);
    }

  if (XFindContext(the_environment.the_display, 
		   bevent->subwindow,
		   comp_xtable, 
		   (caddr_t *) &present_xcomponent) != 0)
    {
      last_xcomponent = NULL;
      return (-1);
    }

  if (present_xcomponent->which_one == INFO_WINDOW)
    {
      last_xcomponent = NULL;
      return (-1);
    }

  if (last_xcomponent == NULL)
    {
      last_xcomponent = present_xcomponent;
      return(1);
    }

  if (present_xcomponent == last_xcomponent)
    {
      return(1);
    }

/* Ok, the user has chosen the peer */
  
  result_flag = (caddr_t) (*last_xcomponent->scomponent->co_action)(NULL,
	   last_xcomponent->scomponent, EV_MK_PEER, NULL,
           present_xcomponent->scomponent);
  if (result_flag) {
     (*present_xcomponent->scomponent->co_action)(NULL,
       present_xcomponent->scomponent, EV_MK_PEER, NULL,
       last_xcomponent->scomponent);
     peer_add(present_xcomponent->scomponent, last_xcomponent->scomponent); 
     if (present_xcomponent->scomponent->co_menu_up != (int) NULL ||
	 last_xcomponent->scomponent->co_menu_up != (int) NULL)
	 update_meters_and_info_windows();
  }

  last_xcomponent = (XCOMPONENT *) NULL;

  return (1);
  
}
#endif /* MOTIF */
#endif /* NoX */

int peer_create()
{
   if (! ((int) peer_list)) {       
      peer_list = l_create();
      return((int) peer_list);
   }
   return(0);
}

int peer_destroy()
{
   lq_delete(peer_list);
   peer_list = (list *) NULL;
   return(1);
}

int peer_add(c1, c2)
Component *c1, *c2;
{
   Peer_Rec *l;

   l = (Peer_Rec *) sim_malloc(sizeof(Peer_Rec));
   l->c1 = c1;
   l->c2 = c2;
   le_addt(peer_list, l); 
   return(1);
}

int peer_and_delete(c1, c2)
Component *c1, *c2;
{
   Peer_Rec *l, *n;

   for (l  = (Peer_Rec *) peer_list->l_head; 
	l != (Peer_Rec *) NULL; 
	l  = n) {
      n = l->next;
      if ((l->c1 == c1 && l->c2 == c2) || (l->c2 == c1 && l->c1 == c2)) {
	 le_del(peer_list, l);
	 free (l);
      }
   }
   return(1);
}

int peer_or_delete(c1, c2)
Component *c1, *c2;
{
   Peer_Rec *l, *n;

   for (l  = (Peer_Rec *) peer_list->l_head; 
	l != (Peer_Rec *) NULL; 
	l  = n) {
      n = l->next;
      if (l->c1 == c1 || l->c2 == c2 || l->c2 == c1 || l->c1 == c2) {
	 le_del(peer_list, l);
	 free (l);
      }
   }
   return(1);
}


