/*$id$*/
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <sys/resource.h>
#include "stat.h"

void print_start_stat(file, argc, argv)
FILE *file;
int argc;
char *argv[];
{
   int i;
   time_t timer;

   fprintf(file, "%s Compiled at %s by %s\n", 
	   STAT_MARS, STAT_COMPILED_AT, STAT_WHOAMI);
   fprintf(file, "  Compiled: %s(%s) %s\n", 
	         STAT_COMPILER, STAT_LINKER, STAT_OPTIONS);
   fprintf(file, "  Options:  "); 
   for (i=0; i<argc; i++) 
      fprintf(file, "%s ", argv[i]);
   fprintf(file, "\n");

   time(&timer);
   fprintf(file, "  Started:  %s", ctime(&timer));

}

void print_end_stat(file)
FILE *file;
{
   time_t timer;

   time(&timer);
   fprintf(file, "  Ended:    %s", ctime(&timer));
}

double tv2f(tv)
struct timeval tv;
/* Converts a timeval into a double giving the time in seconds. */
{
    return tv.tv_sec + tv.tv_usec / 1e6;
}

static struct timeval start_time;

void get_start_time()
{
    gettimeofday(&start_time, NULL);
}

void print_rusage(file)
FILE *file;
{
    struct timeval end_time;
    struct rusage self;
    double rtime, utime, stime;

    getrusage(RUSAGE_SELF, &self);
    gettimeofday(&end_time, NULL);

    utime = tv2f(self.ru_utime);
    stime = tv2f(self.ru_stime);
    rtime = tv2f(end_time) - tv2f(start_time);

    fprintf(file, "  Resource Usage: \n");
    fprintf(file, "     times:    %1.2fu %1.2fs %1.2fr\n", utime, stime, rtime);
    fprintf(file, "     i/o:      %d %d\n", self.ru_inblock, self.ru_oublock);
    fprintf(file, "     faults:   %d %d\n", self.ru_minflt, self.ru_majflt);
    fprintf(file, "     swaps:    %d\n", self.ru_nswap);
    fprintf(file, "     max size: %d * %d\n", self.ru_maxrss, getpagesize());
    fprintf(file, "     ws size:  %d\n", self.ru_idrss);
    fprintf(file, "     signals:  %d\n", self.ru_nsignals);
    fprintf(file, "     vo/nv cs: %d %d\n", self.ru_nvcsw, self.ru_nivcsw);
}

