/***
 * mail.java,v 1.2 1998/03/15 21:00:22
 * Copyright 1997 Original Reusable Objects, Inc.  All rights reserved.
 ***/

import java.io.*;
import java.util.*;

import com.oroinc.net.smtp.*;
import com.oroinc.io.*;

/***
 * This is an example program using the SMTP package to send a message
 * to the specified recipients.  It prompts you for header information and
 * a filename containing the message.
 * <p>
 * Copyright &#169 1997 Original Reusable Objects, Inc.
 * All rights reserved.
 ***/

public final class mail {

  public final static void main(String[] args) {
    String sender, recipient, subject, filename, server, cc;
    Vector ccList = new Vector();
    BufferedReader stdin;
    FileReader fileReader = null;
    Writer writer;
    SimpleSMTPHeader header;
    SMTPClient client;
    Enumeration enum;

    if(args.length < 1) {
      System.err.println("Usage: mail smtpserver");
      System.exit(1);
    }

    server = args[0];

    stdin = new BufferedReader(new InputStreamReader(System.in));

    try {
      System.out.print("From: ");
      System.out.flush();

      sender = stdin.readLine();

      System.out.print("To: ");
      System.out.flush();

      recipient = stdin.readLine();

      System.out.print("Subject: ");
      System.out.flush();

      subject = stdin.readLine();

      header = new SimpleSMTPHeader(sender, recipient, subject);


      while(true) {
	System.out.print("CC <enter one address per line, hit enter to end>: ");
	System.out.flush();

	// Of course you don't want to do this because readLine() may be null
	cc = stdin.readLine().trim();

	if(cc.length() == 0)
	  break;

	header.addCC(cc);
	ccList.addElement(cc);
      }

      System.out.print("Filename: ");
      System.out.flush();

      filename = stdin.readLine();

      try {
	fileReader = new FileReader(filename);
      } catch(FileNotFoundException e) {
	System.err.println("File not found. " + e.getMessage());
      }

      client = new SMTPClient();
      client.addProtocolCommandListener(new PrintCommandListener(
				        new PrintWriter(System.out)));

      client.connect(server);

      if(!SMTPReply.isPositiveCompletion(client.getReplyCode())) {
	client.disconnect();
	System.err.println("SMTP server refused connection.");
	System.exit(1);
      }

      client.login();

      client.setSender(sender);
      client.addRecipient(recipient);

      enum = ccList.elements();

      while(enum.hasMoreElements())
	client.addRecipient((String)enum.nextElement());

      writer = client.sendMessageData();

      if(writer != null) {
	writer.write(header.toString());
	Util.copyReader(fileReader, writer);
	writer.close();
	client.completePendingCommand();
      }

      fileReader.close();

      client.logout();

      client.disconnect();
    } catch(IOException e) {
      e.printStackTrace();
      System.exit(1);
    }
  }
}


