/*
 * $Id: NunniCXMLParser.c,v 1.5 2004/08/06 16:46:38 nunnari Exp $
 *
 * Copyright (c) 2004 Roberto Nunnari - roberto.nunnari@nunnisoft.ch
 * All rights reserved.
 *
 *  This file is part of NunniMCAX.
 *
 *  NunniMCAX is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NunniMCAX is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with NunniFSMGen; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * this file was generated by NunniFSMGen
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "NunniCXMLParser.h"
#include "NunniCXMLParserFSM.h"
#include "NunniMCAX.h"
#include "NunniStack.h"

#define TAGSIZE 100

static struct NunniMCAXContentHandler * _handler;
static int _start;
static int _rootFound;
static int _line;
static char *_tagname;
static char _lvalue[TAGSIZE];
static char _rvalue[TAGSIZE];
static char _dtda[TAGSIZE];
static char _charArray[1];
/*static char _cdata[TAGSIZE];*/
static char _cdataa[TAGSIZE];
static struct NunniHashtable    * _args;
static struct NunniStack        * _stack;

int addArg();


int NunniMCAXparse( FILE *file, struct NunniMCAXContentHandler *handler ) {
    int ci;
	int ret;
    struct NunniCXMLParserFSM *fsm = NunniCXMLParserFSMCreate();
    _stack = NunniStackCreate();

    _handler = handler;
    _start = 1;
    _rootFound = 0;
	_line = 1;
    _args = NunniHashtableCreate();
	_tagname = 0;

    memset( _lvalue, 0, TAGSIZE );
    memset( _rvalue, 0, TAGSIZE );
    memset( _dtda, 0, TAGSIZE );

    while ( ( ci = fgetc( file ) ) != EOF ) {
        char c = (char)ci;
        switch ( c ) {

            case '<':
                ret = NunniCXMLParserFSMopenbracket( fsm, c );
                break;

            case '>':
                ret = NunniCXMLParserFSMclosebracket( fsm, c );
                break;

            case '[':
                ret = NunniCXMLParserFSMopensqbracket( fsm, c );
                break;

            case ']':
                ret = NunniCXMLParserFSMclosesqbracket( fsm, c );
                break;

            case '?':
                ret = NunniCXMLParserFSMquestionmark( fsm, c );
                break;

            case '!':
                ret = NunniCXMLParserFSMescalmatmark( fsm, c );
                break;

            case '-':
                ret = NunniCXMLParserFSMminus( fsm, c );
                break;

            case ' ':
                ret = NunniCXMLParserFSMwhitespace( fsm, c );
                break;

            case '/':
                ret = NunniCXMLParserFSMslash( fsm, c );
                break;

            case '=':
                ret = NunniCXMLParserFSMequal( fsm, c );
                break;

            case '\'':
                ret = NunniCXMLParserFSMsquote( fsm, c );
                break;

            case '"':
                ret = NunniCXMLParserFSMdquote( fsm, c );
                break;

            default:
                if ( '\n' == c ) {
					++_line;
                    break;
                }
                else if ( isspace( c ) ) {
                    ret = NunniCXMLParserFSMwhitespace( fsm, c );
                    break;
                }
                else if ( isalnum( c ) || c=='.' || c=='_' || c==':' ) {
                    ret = NunniCXMLParserFSMliteral( fsm, c );
                    break;
                }
                else {
                    ret = NunniCXMLParserFSMother( fsm, c );
                    break;
                }
        }
		if ( ret < 0 ) {
			if ( _tagname != NULL )
				free( _tagname );
			NunniCXMLParserFSMDelete( fsm );
			NunniStackDelete( _stack );
		    fclose( file );
			return ret;
		}
    }
    NunniCXMLParserFSMend( fsm, 'a' );
	NunniCXMLParserFSMDelete( fsm );
	NunniStackDelete( _stack );
    fclose( file );
	return ret;
}


int preOpenbracket( char o ) {
    /* add your code hereafter... */
    if ( _start ) {
        _start = 0;
        _handler->startDocument();
		_tagname = calloc( 1, TAGSIZE );
    }
    return 0;
}


int pretagstartLiteral( char o ) {
    /* add your code hereafter... */
	_tagname = calloc( 1, TAGSIZE );
    NunniHashtableClear( _args, 1 );
    _tagname[0] = o;
    return 0;
}


int dtdaWhitespace( char o ) {
    /* add your code hereafter... */
    if ( strncmp( _dtda, "DOCTYPE", TAGSIZE ) ) {
        printf( "line %d: Expected 'DOCTYPE', found: '%s'\n", _line, _dtda );
        return -1;
    }
    return 0;
}


int dtdaLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _dtda );
    if ( i == TAGSIZE )
        return -1;
    _dtda[i] = o;
    return 0;
}


int cdataaOpensqbracket( char o ) {
    /* add your code hereafter... */
    if ( strncmp( _cdataa, "CDATA", TAGSIZE ) ) {
        printf( "line %d: expected 'CDATA' but found '%s'\n", _line, _cdataa );
        return -1;
    }
    return 0;
}


int cdataaLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _cdataa );
    if ( i == TAGSIZE )
        return -1;
    _cdataa[i] = o;
    return 0;
}


int cdataLiteral( char o ) {
    /* add your code hereafter... */
    _charArray[0] = o;
    _handler->characters( _charArray, 0, 1 );
    return 0;
}


int cdatabClosesqbracket( char o ) {
    /* add your code hereafter... */
    return 0;
}


int cdatacLiteral( char o ) {
    /* add your code hereafter... */
    _charArray[0] = ']';
    _handler->characters( _charArray, 0, 1 );
    _charArray[0] = o;
    _handler->characters( _charArray, 0, 1 );
    return 0;
}


int cdatacClosesqbracket( char o ) {
    /* add your code hereafter... */
    return 0;
}


int cdatadClosebracket( char o ) {
    /* add your code hereafter... */
    return 0;
}


int commentaOpensqbracket( char o ) {
    /* add your code hereafter... */
    memset( _cdataa, 0, TAGSIZE );
    return 0;
}


int commentaDTD( char o ) {
    /* add your code hereafter... */
    memset( _dtda, 0, TAGSIZE );
    _dtda[0] = o;
    return 0;
}


int textLiteral( char o ) {
    /* add your code hereafter... */
    if ( NunniStackIsEmpty( _stack ) && _rootFound && !isspace( o ) ) {
        printf( "line %d: Unexpected data after end of document!\n", _line );
        return -1;
    }
    _charArray[0] = o;
    _handler->characters( _charArray, 0, 1 );
    return 0;
}


int textEnd( char o ) {
    /* add your code hereafter... */
    if ( !NunniStackIsEmpty( _stack ) ) {
        const char * tag = NunniStackPop( _stack );
        printf( "line %d: Premature end of document: '%s' tag not closed.\n", _line, tag );
        return -1;
    }
    _handler->endDocument();
    return 0;
}


int tagstartSlash( char o ) {
    /* add your code hereafter... */
	_tagname = calloc( 1, TAGSIZE );
    return 0;
}


int tagstartLiteral( char o ) {
    /* add your code hereafter... */
	_tagname = calloc( 1, TAGSIZE );
    NunniHashtableClear( _args, 1 );
    _tagname[0] = o;
    return 0;
}


int closetagnameClosebracket( char o ) {
    /* add your code hereafter... */
	char *otagname = NULL;

	if ( NunniStackIsEmpty( _stack ) ) {
		printf( "line %d: No open tags left on stack!\n", _line );
		return -1;
	}

	otagname = NunniStackPop( _stack );

	if ( strncmp( _tagname, otagname, TAGSIZE ) ) {
		printf( "line %d: open and close tags do not match!\n", _line );
		return -1;
	}
	_handler->endElement( _tagname );
	free( otagname );
    return 0;
}


int closetagnameLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _tagname );
    if ( i == TAGSIZE )
        return -1;
    _tagname[i] = o;
    return 0;
}


int tagnameClosebracket( char o ) {
    /* add your code hereafter... */
    if ( NunniStackIsEmpty( _stack ) && _rootFound )
        puts( "Only one root element is allowed!" );
    _rootFound = 1;
    NunniStackPush(  _stack, _tagname );
    _handler->startElement( _tagname, _args );
    return 0;
}


int tagnameLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _tagname );
    if ( i == TAGSIZE )
        return -1;
    _tagname[i] = o;
    return 0;
}


int tagargsLiteral( char o ) {
    /* add your code hereafter... */
    memset( _lvalue, 0, TAGSIZE );
    _lvalue[0] = o;
    return 0;
}


int lvalueLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _lvalue );
    if ( i == TAGSIZE )
        return -1;
    _lvalue[i] = o;
    return 0;
}


int equalSquote( char o ) {
    /* add your code hereafter... */
    memset( _rvalue, 0, TAGSIZE );
    return 0;
}


int equalDquote( char o ) {
    /* add your code hereafter... */
    memset( _rvalue, 0, TAGSIZE );
    return 0;
}


int sqopenLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _rvalue );
    if ( i == TAGSIZE )
        return -1;
    _rvalue[i] = o;
    return 0;
}


int sqopenQuote( char o ) {
    /* add your code hereafter... */
    return addArg();
}


int dqopenLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _rvalue );
    if ( i == TAGSIZE )
        return -1;
    _rvalue[i] = o;
    return 0;
}


int dqopenQuote( char o ) {
    /* add your code hereafter... */
    return addArg();
}


int rvalueLiteral( char o ) {
    /* add your code hereafter... */
    int i = strlen( _rvalue );
    if ( i == TAGSIZE )
        return -1;
    _rvalue[i] = o;
    return 0;
}


int rvalueQuote( char o ) {
    /* add your code hereafter... */
    return addArg();
}


int addArg() {
    char *lvalue = _lvalue;
    char *rvalue = _rvalue;
    if ( NunniHashtableContains( _args, lvalue ) ) {
        printf( "line %d: arg <%s> exists already!\n", _line, lvalue );
        return -1;
    }
    lvalue = malloc( strlen( _lvalue ) + 1 );
    rvalue = malloc( strlen( _rvalue ) + 1 );
    strcpy( lvalue, _lvalue );
    strcpy( rvalue, _rvalue );
    NunniHashtablePut( _args, lvalue, rvalue );
    return 0;
}


int singletagClosebracket( char o ) {
    /* add your code hereafter... */
    _handler->startElement( _tagname, _args );
    _handler->endElement( _tagname );
    return 0;
}
