/*
 * $Id: NunniHashtable.c,v 1.2 2004/08/05 17:26:09 nunnari Exp $
 *
 * Copyright (c) 2004 Roberto Nunnari - roberto.nunnari@nunnisoft.ch
 * All rights reserved.
 *
 *  This file is part of NunniMCAX.
 *
 *  NunniMCAX is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NunniMCAX is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with NunniFSMGen; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "NunniMCAX.h"

#define INITHASHSIZE 10
/*
#define INITKEYSIZE 30
#define INITVALSIZE 30
*/
struct NunniAssoc {
    char *m_key;
    char *m_val;
};

struct NunniHashtable {
    struct NunniAssoc *m_assoc;
    int m_size, m_totLen;
};



struct NunniHashtable * NunniHashtableCreate() {
    struct NunniHashtable *ht = calloc( 1, sizeof(struct NunniHashtable) );
    ht->m_assoc = calloc( INITHASHSIZE, sizeof(struct NunniAssoc) );
    ht->m_totLen = INITHASHSIZE;
    return ht;
}


void NunniHashtableDelete( struct NunniHashtable *ht ) {
    free( ht->m_assoc );
    free( ht );
}


int NunniHashtableIsEmpty( struct NunniHashtable *ht ) {
    return ht->m_size == 0;
}


int NunniHashtablePut( struct NunniHashtable *ht, char *key, char *value ) {
    int i, valLen, newsize;
    int found = 0;
    struct NunniAssoc *assoc;

    if ( key == NULL || value == NULL )
        return -1;

    valLen = strlen( value );

    for ( i = 0; i < ht->m_size; ++i ) {
        assoc = &(ht->m_assoc[i]);
        if ( !strcmp( assoc->m_key, key ) ) {
            found = 1;
            break;
        }
    }

    if ( found ) {
        return -1;
    }
    else if ( ht->m_size == ht->m_totLen ) {
        newsize = ht->m_totLen + INITHASHSIZE;
        assoc = realloc( ht->m_assoc, newsize * sizeof(struct NunniAssoc) );
        if ( assoc == NULL )
            return -1;
        ht->m_assoc = assoc;
        ht->m_totLen = newsize;
    }
    assoc = &(ht->m_assoc[ht->m_size++]);
    assoc->m_key = key;
    assoc->m_val = value;
    return 0;
}


const char * NunniHashtableGet( struct NunniHashtable *ht, const char *key ) {
    int i ;
    struct NunniAssoc *assoc;

    if ( key == NULL )
        return NULL;

    for ( i = 0; i < ht->m_size; ++i ) {
        assoc = &(ht->m_assoc[i]);
        if ( !strcmp( assoc->m_key, key ) )
            return assoc->m_val;
    }
        
    return NULL;
}


int NunniHashtableContains( struct NunniHashtable *ht, const char *key ) {
    int i = 0;
    struct NunniAssoc *assoc;

    if ( key == NULL )
        return 0;

    for ( i = 0; i < ht->m_size; ++i ) {
        assoc = &(ht->m_assoc[i]);
        if ( !strcmp( assoc->m_key, key ) )
            return 1;
    }
    return 0;
}


int NunniHashtableSize( struct NunniHashtable *ht ) {
    return ht->m_size;
}


int NunniHashtableKeys( struct NunniHashtable *ht, char *keys[] ) {
    int i;
    for( i = 0; i < ht->m_size; ++i )
        keys[i] = ht->m_assoc[i].m_key;
    return i;
}

void NunniHashtableClear( struct NunniHashtable *ht, int freeup ) {
    int i;
    if ( freeup ) {
        for ( i = 0; i < ht->m_size; ++i ) {
            free( ht->m_assoc[i].m_key );
            free( ht->m_assoc[i].m_val );
        }
    }
    free( ht->m_assoc );
    ht->m_assoc = calloc( INITHASHSIZE, sizeof(struct NunniAssoc) );
    ht->m_totLen = INITHASHSIZE;
    ht->m_size = 0;
}

