/*
 * $Id: NunniStack.c,v 1.2 2004/08/06 16:46:38 nunnari Exp $
 *
 * Copyright (c) 2004 Roberto Nunnari - roberto.nunnari@nunnisoft.ch
 * All rights reserved.
 *
 *  This file is part of NunniMCAX.
 *
 *  NunniMCAX is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NunniMCAX is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with NunniFSMGen; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include "NunniStack.h"

#define INITSTACKSIZE 8


struct NunniStack {
	/* the stack of strings */
	char ** m_stack;
	/* the stack pointer and total size */
    int m_sp, m_totLen;
};



struct NunniStack * NunniStackCreate() {
    struct NunniStack *st = calloc( 1, sizeof(struct NunniStack) );
    st->m_stack = calloc( INITSTACKSIZE, sizeof(char *) );
    st->m_sp = 0;
    st->m_totLen = INITSTACKSIZE;
    return st;
}


void NunniStackDelete( struct NunniStack *st ) {

	int i;

	if ( st == NULL || st->m_stack == NULL )
		return;

	for ( i = 0; i < st->m_sp; ++i )
		if ( st->m_stack[i] != NULL )
			free( st->m_stack[i] );

    free( st->m_stack );
    free( st );
}


int NunniStackIsEmpty( struct NunniStack *st ) {
    return st->m_sp == 0;
}


int NunniStackPush( struct NunniStack *st, char *s ) {
	int newsize;
	char **newstack;

    if ( st->m_sp == st->m_totLen ) {
        newsize = st->m_totLen + INITSTACKSIZE;
        newstack = realloc( st->m_stack, newsize * sizeof( char * ) );
        if ( newstack == NULL )
            return -1;
        st->m_stack = newstack;
        st->m_totLen = newsize;
    }
	st->m_stack[st->m_sp++] = s;

    return 0;
}


char * NunniStackPop( struct NunniStack *st ) {
    if ( st->m_sp > 0 )
        return st->m_stack[--(st->m_sp)];
    else
        return NULL;
}
