/*
 * $Id: nmcaxwf.c,v 1.2 2004/08/11 19:25:13 nunnari Exp $
 *
 * Copyright (c) 2004 Roberto Nunnari - roberto.nunnari@nunnisoft.ch
 * All rights reserved.
 *
 *  This file is part of NunniMCAX.
 *
 *  NunniMCAX is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NunniMCAX is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with NunniFSMGen; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <string.h>
#include "NunniMCAX.h"


static int startDocument(void) {
    return 0;
}

static int startElement( const char *tagname, struct NunniHashtable *args ) {
    return 0;
}

static int characters( char ch[], int start, int length ) {
    return 0;
}

static int endElement( const char *tagname ) {
    return 0;
}

static int endDocument(void) {
    return 0;
}


int main( int argc, char *argv[] ) {
    FILE * file = NULL;
	int retCode;

    /* we need a handler for callback functions */
    struct NunniMCAXContentHandler handler;

    if ( argc < 2 ) {
        printf( "usage: %s xmldocument", argv[0] );
        return -1;
    }

    file = fopen( argv[1], "r" );
	if ( file == NULL ) {
		printf( "ERROR: cannot open file %s\n", argv[1] );
		return -1;
	}

    /* set up the handler functions */
    handler.startDocument = startDocument;
    handler.startElement = startElement;
    handler.characters = characters;
    handler.endElement = endElement;
    handler.endDocument = endDocument;

    /* ok, let's do the job */
    retCode = NunniMCAXparse( file, &handler );

	if ( retCode != 0 ) {
        printf( "ERROR! document %s is not well-formed XML!\n", argv[1] );
        return -1;
	}

    return 0;
}
