/*
 * $Id: reporter.c,v 1.1 2004/08/06 16:46:38 nunnari Exp $
 *
 * Copyright (c) 2004 Roberto Nunnari - roberto.nunnari@nunnisoft.ch
 * All rights reserved.
 *
 *  This file is part of NunniMCAX.
 *
 *  NunniMCAX is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NunniMCAX is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with NunniFSMGen; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "NunniMCAX.h"

#define MAXLEN 40000

static char m_characters[MAXLEN];

static int startDocument(void) {
    puts( "startDocument" );
    return 0;
}

static int startElement( const char *tagname, struct NunniHashtable *args ) {
	/* be careful with args.. when this function returns all strings
		there hold are freed by the parser. That means that if you need
		the contents of args after this function returns, you need to
		do a deep copy to local variables.
	*/
    const int size = NunniHashtableSize( args );
    char ** keys;
    int i, ret;
    const char *name, *value;
	keys = calloc( size, sizeof( char * ) );
    printf( "start element: %s\n", tagname );
    ret = NunniHashtableKeys( args, keys );
    for ( i = 0; i < size; ++i ) {
        name = keys[i];
        value = NunniHashtableGet( args, name );
        printf( "  attrName: \"%s\"   attrValue: \"%s\"\n", name, value );
    }
    memset( m_characters, 0, MAXLEN );
    return 0;
}

static int characters( char ch[], int start, int length ) {
    int i = strlen( m_characters );
    if ( i == MAXLEN )
        return -1;
    strncat( m_characters, &(ch[start]), length );
    return 0;
}

static int endElement( const char *tagname ) {
    int len;
    char *data = m_characters;
    while( isspace( *data ) ) {
        ++data;
    }
    len = strlen( data );
    while( isspace( data[--len] ) ) {
        data[len] = 0;
    }
    if ( data != NULL && strncmp( data, "", 1 ) )
        printf( "%s\n", data );
    memset( m_characters, 0, MAXLEN );
    printf( "end element: %s\n", tagname );
    return 0;
}

static int endDocument(void) {
    puts( "endDocument" );
    return 0;
}


int main( int argc, char *argv[] ) {
    FILE * file = NULL;
	int retCode;

    /* we need a handler for callback functions */
    struct NunniMCAXContentHandler handler;

    if ( argc < 2 ) {
        printf( "usage: %s xmldocument", argv[0] );
        return -1;
    }

    file = fopen( argv[1], "r" );
	if ( file == NULL ) {
		printf( "ERROR: cannot open file %s\n", argv[1] );
		return -1;
	}

    /* set up the handler functions */
    handler.startDocument = startDocument;
    handler.startElement = startElement;
    handler.characters = characters;
    handler.endElement = endElement;
    handler.endDocument = endDocument;

    /* ok, let's do the job */
    retCode = NunniMCAXparse( file, &handler );

	if ( retCode != 0 ) {
        printf( "ERROR! document %s is not well-formed XML!", argv[1] );
        return -1;
	}

    puts( "done." );
    return 0;
}
