/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Enumeration;

class ScCanvas
extends Canvas {
    Dimension preferredSize;
    Dimension minimumSize;
    Image offImage = null;
    Image lupe = null;
    Image im = null;
    int lupeX = 0;
    int lupeY = 0;
    boolean showLupe = false;
    boolean ready = false;
    Graphics offGraphics = null;
    Graphics lupeGraphics = null;
    int w = 100;
    int h = 100;
    ptproject project;
    static final int LUPE_WIDTH = 60;
    public int index = 0;

    public ScCanvas(int n, ptproject ptproject2) {
        this.project = ptproject2;
        this.index = n;
        if (n >= 0) {
            this.im = this.project.gl.utils.ptLoadImage(n);
        }
        if (this.im != null) {
            this.w = (int)((double)this.im.getWidth(null) * this.project.gl.zoom);
            this.h = (int)((double)this.im.getHeight(null) * this.project.gl.zoom);
        }
        this.preferredSize = new Dimension(this.w, this.h);
        this.minimumSize = new Dimension(10, 10);
        this.ready = true;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.ready || this.im == null) {
            return;
        }
        if (this.offImage == null) {
            this.offImage = this.createImage(this.w, this.h);
            this.offGraphics = this.offImage.getGraphics();
            this.offGraphics.drawImage(this.im, 0, 0, this.w, this.h, this);
            if (this.project.gl.showTriangles) {
                this.drawTriangles(this.offGraphics);
            }
            this.drawControlPoints(this.offGraphics);
            this.project.dirty[this.index] = false;
        }
        if (this.offGraphics == null) {
            return;
        }
        if (this.project.dirty[this.index]) {
            this.offGraphics.drawImage(this.im, 0, 0, this.w, this.h, this);
            if (this.project.gl.showTriangles) {
                this.drawTriangles(this.offGraphics);
            }
            this.drawControlPoints(this.offGraphics);
            this.project.dirty[this.index] = false;
        }
        graphics.drawImage(this.offImage, 0, 0, this.w, this.h, this);
        if (this.showLupe) {
            graphics.drawImage(this.offImage, this.lupeX - 30, this.lupeY - 30, this.lupeX + 30, this.lupeY + 30, this.lupeX - 15, this.lupeY - 15, this.lupeX + 15, this.lupeY + 15, this);
        }
        if (((ptScrollPane)this.getParent().getParent()).select && !this.project.gl.mousePressedPoint.equals(this.project.gl.mouseDragPoint)) {
            Point point = this.project.gl.mousePressedPoint;
            Point point2 = this.project.gl.mouseDragPoint;
            graphics.setColor(Color.black);
            graphics.drawRect(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point.x - point2.x), Math.abs(point.y - point2.y));
        }
        if (this.showLupe && this.project.gl.drag >= 0) {
            int n = (int)(2.0 * Double.valueOf(this.project.gl.properties.getProperty("PointRadius")));
            graphics.setColor(Color.black);
            graphics.drawOval(this.lupeX - n, this.lupeY - n, 2 * n, 2 * n);
        }
    }

    public synchronized void disposeGraphics() {
        if (this.lupeGraphics != null) {
            this.lupeGraphics.dispose();
            this.lupeGraphics = null;
        }
        if (this.offGraphics != null) {
            this.offGraphics.dispose();
            this.offGraphics = null;
        }
        if (this.im != null) {
            this.im.flush();
            this.im = null;
        }
        if (this.offImage != null) {
            this.offImage.flush();
            this.offImage = null;
        }
        if (this.lupe != null) {
            this.lupe.flush();
            this.lupe = null;
        }
    }

    void drawTriangles(Graphics graphics) {
        if (this.project.nt == 0) {
            return;
        }
        Enumeration enumeration = this.project.tr.elements();
        while (enumeration.hasMoreElements()) {
            try {
                triangle triangle2 = (triangle)enumeration.nextElement();
                if (triangle2.nIm != this.index) continue;
                controlPoint controlPoint2 = (controlPoint)this.project.cp.get(new Integer(triangle2.vert[0]));
                int n = controlPoint2.n[0] == this.index ? 0 : 1;
                controlPoint controlPoint3 = (controlPoint)this.project.cp.get(new Integer(triangle2.vert[1]));
                int n2 = controlPoint3.n[0] == this.index ? 0 : 1;
                controlPoint controlPoint4 = (controlPoint)this.project.cp.get(new Integer(triangle2.vert[2]));
                int n3 = controlPoint4.n[0] == this.index ? 0 : 1;
                Polygon polygon = new Polygon(new int[]{(int)(controlPoint2.x[n] * this.project.gl.zoom), (int)(controlPoint3.x[n2] * this.project.gl.zoom), (int)(controlPoint4.x[n3] * this.project.gl.zoom)}, new int[]{(int)(controlPoint2.y[n] * this.project.gl.zoom), (int)(controlPoint3.y[n2] * this.project.gl.zoom), (int)(controlPoint4.y[n3] * this.project.gl.zoom)}, 3);
                graphics.setColor(Color.gray);
                int n4 = Math.min(polygon.xpoints[0], Math.min(polygon.xpoints[1], polygon.xpoints[2]));
                int n5 = Math.max(polygon.xpoints[0], Math.max(polygon.xpoints[1], polygon.xpoints[2]));
                int n6 = Math.min(polygon.ypoints[0], Math.min(polygon.ypoints[1], polygon.ypoints[2]));
                int n7 = Math.max(polygon.ypoints[0], Math.max(polygon.ypoints[1], polygon.ypoints[2]));
                int n8 = n6;
                boolean bl = true;
                while (n8 <= n7) {
                    int n9 = bl ? n4 : n4 + 1;
                    while (n9 < n5) {
                        if (polygon.contains(n9, n8)) {
                            graphics.drawLine(n9, n8, n9, n8);
                        }
                        n9 += 2;
                    }
                    ++n8;
                    boolean bl2 = bl = !bl;
                }
                graphics.setColor(Color.black);
                graphics.drawPolygon(polygon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void drawControlPoints(Graphics graphics) {
        int n = this.index == this.project.gl.leftindex ? this.project.gl.rightindex : this.project.gl.leftindex;
        double d = Double.valueOf(this.project.gl.properties.getProperty("PointRadius"));
        int n2 = (int)(d * 2.0);
        Color color = new Color(Integer.parseInt(this.project.gl.properties.getProperty("SelectColor"), 16));
        Color color2 = new Color(Integer.parseInt(this.project.gl.properties.getProperty("SingleColor"), 16));
        Color color3 = new Color(Integer.parseInt(this.project.gl.properties.getProperty("LinkedColor"), 16));
        Enumeration enumeration = this.project.cp.elements();
        while (enumeration.hasMoreElements()) {
            try {
                int n3;
                int n4;
                controlPoint controlPoint2 = (controlPoint)enumeration.nextElement();
                if (controlPoint2.n[0] == this.index && (this.project.gl.showAllPoints || controlPoint2.n[1] == n)) {
                    n4 = (int)(controlPoint2.x[0] * this.project.gl.zoom - d);
                    n3 = (int)(controlPoint2.y[0] * this.project.gl.zoom - d);
                    if (controlPoint2.select) {
                        graphics.setColor(color);
                    } else if (controlPoint2.n[1] == n) {
                        graphics.setColor(color3);
                    } else {
                        graphics.setColor(color2);
                    }
                    graphics.fillOval(n4, n3, n2, n2);
                    graphics.setColor(Color.black);
                    graphics.drawOval(n4, n3, n2, n2);
                    continue;
                }
                if (controlPoint2.n[1] != this.index || !this.project.gl.showAllPoints && controlPoint2.n[0] != n) continue;
                n4 = (int)(controlPoint2.x[1] * this.project.gl.zoom - d);
                n3 = (int)(controlPoint2.y[1] * this.project.gl.zoom - d);
                if (controlPoint2.select) {
                    graphics.setColor(color);
                } else if (controlPoint2.n[0] == n) {
                    graphics.setColor(color3);
                } else {
                    graphics.setColor(color2);
                }
                graphics.fillOval(n4, n3, n2, n2);
                graphics.setColor(Color.black);
                graphics.drawOval(n4, n3, n2, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void magnify(int n, int n2) {
        this.lupeX = n;
        this.lupeY = n2;
        this.showLupe = true;
    }

    public void unmagnify() {
        this.showLupe = false;
    }
}

