/*
 * Decompiled with CFR 0.152.
 */
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJQuitHandler;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;

public class ptpicker
extends Frame
implements ActionListener,
MRJAboutHandler,
MRJOpenDocumentHandler,
MRJQuitHandler {
    ptproject project;
    ptScrollPane left;
    ptScrollPane right;
    static ptglobals globals;
    static ptpicker picker;
    Menu ml = null;
    Menu mr = null;

    public static void main(String[] stringArray) {
        String string = null;
        globals = new ptglobals();
        if (!ptpicker.globals.utils.success) {
            System.out.println("Could not load library pano12");
        }
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        picker = new ptpicker(string);
    }

    public ptpicker(String string) {
        if (MRJApplicationUtils.isMRJToolkitAvailable()) {
            MRJApplicationUtils.registerAboutHandler(this);
            MRJApplicationUtils.registerOpenDocumentHandler(this);
            MRJApplicationUtils.registerQuitHandler(this);
        }
        ptpicker.globals.picker = this;
        this.project = new ptproject(string, globals);
        if (string != null) {
            this.setTitle(string);
        } else {
            this.setTitle("PTPicker - no project loaded");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if ((ptpicker)windowEvent.getWindow() == picker) {
                    ptpicker.this.handleQuit();
                } else {
                    windowEvent.getWindow().dispose();
                    System.gc();
                }
            }
        });
        this.setPTPickerMenu();
        this.setLayout(new GridLayout(1, 2));
        this.left = new ptScrollPane(this.project);
        this.left.select = true;
        this.add(this.left);
        this.right = new ptScrollPane(this.project);
        this.add(this.right);
        ((Component)this).setSize(500, 320);
        ((Component)this).setVisible(true);
    }

    public void handleAbout() {
        ptpicker.globals.utils.PrintError("PTPicker v.2.2 1999-2000 \u00a9 H.Dersch, der@fh-furtwangen.de");
    }

    public void handleQuit() {
        if (this.project != null && !this.project.isSaved) {
            ptyesno ptyesno2 = new ptyesno((Frame)this, "Current project has not been saved. Discard?");
            ((Component)ptyesno2).setVisible(true);
            if (!ptyesno2.result) {
                return;
            }
        }
        System.exit(0);
    }

    public void handleOpenFile(File file) {
        if (picker != null) {
            ((Component)picker).setVisible(false);
            picker.dispose();
            picker = null;
            System.gc();
        }
        try {
            picker = file == null ? new ptpicker(null) : new ptpicker(file.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setPTPickerMenu() {
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("File");
        menuBar.add(menu);
        MenuItem menuItem = new MenuItem("New");
        menuItem.setShortcut(new MenuShortcut(78));
        menu.add(menuItem);
        MenuItem menuItem2 = new MenuItem("Open");
        menuItem2.setShortcut(new MenuShortcut(79));
        menu.add(menuItem2);
        menu.addSeparator();
        MenuItem menuItem3 = new MenuItem("Close");
        menuItem3.setShortcut(new MenuShortcut(87));
        menu.add(menuItem3);
        MenuItem menuItem4 = new MenuItem("Save");
        menuItem4.setShortcut(new MenuShortcut(83));
        menu.add(menuItem4);
        menu.add(new MenuItem("Save as..."));
        menu.add(new MenuItem("Revert to Saved"));
        menu.addSeparator();
        MenuItem menuItem5 = new MenuItem("Quit");
        menuItem5.setShortcut(new MenuShortcut(81));
        menu.add(menuItem5);
        Menu menu2 = new Menu("Edit");
        menuBar.add(menu2);
        MenuItem menuItem6 = new MenuItem("Undo");
        menuItem6.setEnabled(false);
        menu2.add(menuItem6);
        menu2.addSeparator();
        MenuItem menuItem7 = new MenuItem("Cut");
        menuItem7.setEnabled(false);
        menu2.add(menuItem7);
        MenuItem menuItem8 = new MenuItem("Copy");
        menuItem8.setEnabled(false);
        menu2.add(menuItem8);
        MenuItem menuItem9 = new MenuItem("Paste");
        menuItem9.setEnabled(false);
        menu2.add(menuItem9);
        MenuItem menuItem10 = new MenuItem("Clear");
        menuItem10.setShortcut(new MenuShortcut(12));
        menu2.add(menuItem10);
        menu2.addSeparator();
        MenuItem menuItem11 = new MenuItem("Select All");
        menuItem11.setShortcut(new MenuShortcut(65));
        menu2.add(menuItem11);
        MenuItem menuItem12 = new MenuItem("Deselect");
        menu2.add(menuItem12);
        menu2.addSeparator();
        MenuItem menuItem13 = new MenuItem("Select");
        menu2.add(menuItem13);
        MenuItem menuItem14 = new MenuItem("Set Points");
        menu2.add(menuItem14);
        menu2.addSeparator();
        MenuItem menuItem15 = new MenuItem("Set Triangle");
        menu2.add(menuItem15);
        MenuItem menuItem16 = new MenuItem("Remove Triangle");
        menu2.add(menuItem16);
        MenuItem menuItem17 = new MenuItem("Copy Triangles");
        menu2.add(menuItem17);
        MenuItem menuItem18 = new MenuItem("Triangulate");
        menu2.add(menuItem18);
        MenuItem menuItem19 = new MenuItem("Reduce");
        menu2.add(menuItem19);
        menu2.addSeparator();
        MenuItem menuItem20 = new MenuItem("Find");
        menuItem20.setShortcut(new MenuShortcut(70));
        menu2.add(menuItem20);
        menu2.addSeparator();
        MenuItem menuItem21 = new MenuItem("Align");
        menuItem21.setShortcut(new MenuShortcut(66));
        menu2.add(menuItem21);
        Menu menu3 = new Menu("View");
        menuBar.add(menu3);
        MenuItem menuItem22 = new MenuItem("Zoom In");
        menu3.add(menuItem22);
        MenuItem menuItem23 = new MenuItem("Zoom Out");
        menu3.add(menuItem23);
        MenuItem menuItem24 = new MenuItem("Normal");
        menu3.add(menuItem24);
        menu3.addSeparator();
        Menu menu4 = new Menu("Point Colors");
        menu3.add(menu4);
        MenuItem menuItem25 = new MenuItem("Select");
        menu4.add(menuItem25);
        MenuItem menuItem26 = new MenuItem("Linked");
        menu4.add(menuItem26);
        MenuItem menuItem27 = new MenuItem("Single");
        menu4.add(menuItem27);
        MenuItem menuItem28 = new MenuItem("Point Size");
        menu3.add(menuItem28);
        MenuItem menuItem29 = new MenuItem("Show All Points");
        menu3.add(menuItem29);
        MenuItem menuItem30 = new MenuItem("Show Linked Points");
        menu3.add(menuItem30);
        menu3.addSeparator();
        MenuItem menuItem31 = new MenuItem("Show Triangles");
        menu3.add(menuItem31);
        MenuItem menuItem32 = new MenuItem("Hide Triangles");
        menu3.add(menuItem32);
        Menu menu5 = new Menu("Project");
        menuBar.add(menu5);
        MenuItem menuItem33 = new MenuItem("View Script");
        menu5.add(menuItem33);
        menu5.addSeparator();
        MenuItem menuItem34 = new MenuItem("Optimizer");
        menu5.add(menuItem34);
        MenuItem menuItem35 = new MenuItem("Stitcher");
        menu5.add(menuItem35);
        menu5.addSeparator();
        MenuItem menuItem36 = new MenuItem("3D Stereo");
        menu5.add(menuItem36);
        menu5.addSeparator();
        MenuItem menuItem37 = new MenuItem("Morph");
        menu5.add(menuItem37);
        MenuItem menuItem38 = new MenuItem("Interpolate");
        menu5.add(menuItem38);
        this.ml = new Menu("Left Image");
        menuBar.add(this.ml);
        this.mr = new Menu("Right Image");
        menuBar.add(this.mr);
        this.SetImageMenus();
        menu.addActionListener(this);
        menu2.addActionListener(this);
        menu3.addActionListener(this);
        menu4.addActionListener(this);
        menu5.addActionListener(this);
        this.ml.addActionListener(this);
        this.mr.addActionListener(this);
    }

    void SetImageMenus() {
        if (this.ml != null) {
            this.ml.removeAll();
        }
        if (this.mr != null) {
            this.mr.removeAll();
        }
        this.ml.add(new MenuItem("Close"));
        this.ml.addSeparator();
        this.mr.add(new MenuItem("Close"));
        this.mr.addSeparator();
        int n = 0;
        while (n < this.project.numIm) {
            this.ml.add(new MenuItem(ptpicker.globals.utils.getImageName(n)));
            this.mr.add(new MenuItem(ptpicker.globals.utils.getImageName(n)));
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((MenuItem)actionEvent.getSource()).getLabel();
        String string2 = actionEvent.getActionCommand();
        if (string.equals("File")) {
            if (string2.equals("New")) {
                Dialog dialog;
                if (!this.project.isSaved) {
                    dialog = new ptyesno((Frame)this, "Current project has not been saved. Discard?");
                    ((Component)dialog).setVisible(true);
                    if (!((ptyesno)dialog).result) {
                        return;
                    }
                }
                dialog = new ptedit(this, globals);
                ((Component)dialog).setVisible(true);
                if (((ptedit)dialog).result) {
                    FileDialog fileDialog = new FileDialog((Frame)this, "Save New Project as...", 1);
                    fileDialog.show();
                    if (fileDialog.getFile() != null) {
                        String string3 = fileDialog.getDirectory() + fileDialog.getFile();
                        ptpicker.globals.utils.createProject(string3);
                        this.handleOpenFile(new File(string3));
                    }
                }
            } else if (string2.equals("Open")) {
                Dialog dialog;
                if (!this.project.isSaved) {
                    dialog = new ptyesno((Frame)this, "Current project has not been saved. Discard?");
                    ((Component)dialog).setVisible(true);
                    if (!((ptyesno)dialog).result) {
                        return;
                    }
                }
                dialog = new FileDialog((Frame)this, "Find Project File");
                dialog.show();
                if (((FileDialog)dialog).getFile() != null) {
                    this.handleOpenFile(new File(((FileDialog)dialog).getDirectory() + ((FileDialog)dialog).getFile()));
                }
            } else if (string2.equals("Close")) {
                if (!this.project.isSaved) {
                    ptyesno ptyesno2 = new ptyesno((Frame)this, "Current project has not been saved. Discard?");
                    ((Component)ptyesno2).setVisible(true);
                    if (!ptyesno2.result) {
                        return;
                    }
                }
                this.handleOpenFile(null);
                this.repaint();
            } else if (string2.equals("Save")) {
                this.project.saveProject();
            } else if (string2.equals("Save as...")) {
                FileDialog fileDialog = new FileDialog((Frame)this, "Save Project as...", 1);
                fileDialog.show();
                if (fileDialog.getFile() != null) {
                    this.project.saveProject(fileDialog.getDirectory() + fileDialog.getFile());
                    this.handleOpenFile(new File(fileDialog.getDirectory() + fileDialog.getFile()));
                    this.repaint();
                }
            } else if (string2.equals("Revert to Saved")) {
                if (!this.project.isSaved) {
                    ptyesno ptyesno3 = new ptyesno((Frame)this, "Changes have not been saved. Discard?");
                    ((Component)ptyesno3).setVisible(true);
                    if (!ptyesno3.result) {
                        return;
                    }
                }
                this.handleOpenFile(new File(this.project.name));
                this.repaint();
            } else if (string2.equals("Quit")) {
                this.handleQuit();
            }
        } else if (string.equals("Edit")) {
            if (string2.equals("Clear")) {
                this.project.removeControlPoints();
                this.repaintCanvas();
            } else if (string2.equals("Select All")) {
                int n = this.right.index;
                int n2 = this.left.index;
                if (this.left.select) {
                    n = this.left.index;
                    n2 = this.right.index;
                }
                if (ptpicker.globals.showAllPoints) {
                    this.project.selectAllPoints(n);
                } else {
                    this.project.selectAllPoints(n, n2);
                }
                this.repaintCanvas();
            } else if (string2.equals("Deselect")) {
                this.project.deselectAllPoints();
                this.repaintCanvas();
            } else if (string2.equals("Select")) {
                ptpicker.globals.setPoints = false;
            } else if (string2.equals("Set Points")) {
                ptpicker.globals.setPoints = true;
            } else if (string2.equals("Set Triangle")) {
                if (this.left.select) {
                    this.project.addTriangle(this.left.index);
                } else {
                    this.project.addTriangle(this.right.index);
                }
                this.repaintCanvas();
            } else if (string2.equals("Remove Triangle")) {
                this.project.removeTriangle();
                this.repaintCanvas();
            } else if (string2.equals("Copy Triangles")) {
                int n = this.right.index;
                int n3 = this.left.index;
                if (this.left.select) {
                    n = this.left.index;
                    n3 = this.right.index;
                }
                if (this.project.getImageTriangleCount(n3) > 0) {
                    ptyesno ptyesno4 = new ptyesno((Frame)this, "All triangles in image " + n3 + " will be reset. Continue?");
                    ((Component)ptyesno4).setVisible(true);
                    if (!ptyesno4.result) {
                        return;
                    }
                }
                this.project.copyTriangles(n, n3);
                this.project.isSaved = false;
                this.repaintCanvas();
            } else if (string2.equals("Triangulate")) {
                int n;
                int n4 = n = this.left.select ? this.left.index : this.right.index;
                if (this.project.getImageTriangleCount(n) > 0) {
                    ptyesno ptyesno5 = new ptyesno((Frame)this, "All triangles in this image will be reset. Continue?");
                    ((Component)ptyesno5).setVisible(true);
                    if (!ptyesno5.result) {
                        return;
                    }
                }
                ptpicker.globals.utils.triangulate(n, this.project);
                this.project.isSaved = false;
                this.repaintCanvas();
            } else if (string2.equals("Reduce")) {
                int n;
                int n5 = n = this.left.select ? this.left.index : this.right.index;
                if (this.project.getImageTriangleCount(n) > 0) {
                    ptyesno ptyesno6 = new ptyesno((Frame)this, "All triangles in this image will be reset. Continue?");
                    ((Component)ptyesno6).setVisible(true);
                    if (!ptyesno6.result) {
                        return;
                    }
                }
                ptpicker.globals.utils.reduce(n, this.project);
                this.project.isSaved = false;
                this.repaintCanvas();
            } else if (string2.equals("Find")) {
                int n;
                pttextdialog pttextdialog2 = new pttextdialog(this, "Find", "Find Controlpoint Number:", globals, "find");
                ((Component)pttextdialog2).setVisible(true);
                if (pttextdialog2.result && (n = Integer.parseInt(ptpicker.globals.properties.getProperty("find"))) >= 0 && n < this.project.nc) {
                    controlPoint controlPoint2 = (controlPoint)this.project.cp.get(new Integer(n));
                    this.left.LoadImage(controlPoint2.n[0]);
                    ptpicker.globals.leftindex = controlPoint2.n[0];
                    this.left.sp.setScrollPosition((int)(controlPoint2.x[0] * ptpicker.globals.zoom), (int)(controlPoint2.y[0] * ptpicker.globals.zoom));
                    this.right.LoadImage(controlPoint2.n[1]);
                    ptpicker.globals.rightindex = controlPoint2.n[1];
                    this.right.sp.setScrollPosition((int)(controlPoint2.x[1] * ptpicker.globals.zoom), (int)(controlPoint2.y[1] * ptpicker.globals.zoom));
                    this.project.selectPoint(n);
                    this.repaintCanvas();
                }
            } else if (string2.equals("Align") && this.project != null) {
                this.project.alignSelectedPoints(this.left, this.right);
                this.repaintCanvas();
            }
        } else if (string.equals("View")) {
            if (string2.equals("Zoom In")) {
                ptpicker.globals.zoom *= 2.0;
                this.resetScrollPanes();
            } else if (string2.equals("Zoom Out")) {
                ptpicker.globals.zoom /= 2.0;
                this.resetScrollPanes();
            } else if (string2.equals("Normal")) {
                if (ptpicker.globals.zoom != 1.0) {
                    ptpicker.globals.zoom = 1.0;
                    this.resetScrollPanes();
                }
            } else if (string2.equals("Point Size")) {
                pttextdialog pttextdialog3 = new pttextdialog(this, "Point Size", "Enter Radius of Points (Pixels)", globals, "PointRadius");
                ((Component)pttextdialog3).setVisible(true);
                if (pttextdialog3.result) {
                    this.repaintAll();
                }
            } else if (string2.equals("Show All Points")) {
                ptpicker.globals.showAllPoints = true;
                this.repaintAll();
            } else if (string2.equals("Show Linked Points")) {
                ptpicker.globals.showAllPoints = false;
                this.project.deselectAllPoints();
                this.repaintAll();
            } else if (string2.equals("Show Triangles")) {
                ptpicker.globals.showTriangles = true;
                this.repaintAll();
            } else if (string2.equals("Hide Triangles")) {
                ptpicker.globals.showTriangles = false;
                this.repaintAll();
            }
        } else if (string.equals("Project")) {
            if (string2.equals("Optimizer")) {
                this.project.saveProject();
                ptpicker.globals.utils.CLaunchAndSendScript("PTOptimizer", "");
            } else if (string2.equals("View Script")) {
                ptpicker.globals.utils.CShowScript();
            } else if (string2.equals("Stitcher")) {
                ptpicker.globals.utils.CLaunchAndSendScript("PTStitcher", "");
            } else if (string2.equals("3D Stereo")) {
                ptpicker.globals.utils.CLaunchAndSendScript("PTStereo", "");
            } else if (string2.equals("Morph")) {
                ptpicker.globals.utils.CLaunchAndSendScript("PTMorpher", "");
            } else if (string2.equals("Interpolate")) {
                ptpicker.globals.utils.CLaunchAndSendScript("PTInterpolate", "");
            }
        } else if (string.equals("Left Image")) {
            this.project.setdirty();
            if (string2.equals("Close")) {
                this.left.LoadImage(-1);
                ptpicker.globals.leftindex = -1;
                this.repaintCanvas();
            } else {
                try {
                    this.LoadImage(string2, this.left);
                    ptpicker.globals.leftindex = this.left.index;
                }
                catch (Exception exception) {}
            }
        } else if (string.equals("Right Image")) {
            this.project.setdirty();
            if (string2.equals("Close")) {
                this.right.LoadImage(-1);
                ptpicker.globals.rightindex = -1;
                this.repaintCanvas();
            } else {
                try {
                    this.LoadImage(string2, this.right);
                    ptpicker.globals.rightindex = this.right.index;
                }
                catch (Exception exception) {}
            }
        } else if (string.equals("Point Colors")) {
            if (string2.equals("Select")) {
                pttextdialog pttextdialog4 = new pttextdialog(this, "Set Color as Hexstring (RRGGBB)", "Color for Selected Points", globals, "SelectColor");
                ((Component)pttextdialog4).setVisible(true);
                if (pttextdialog4.result) {
                    this.repaintAll();
                }
            } else if (string2.equals("Linked")) {
                pttextdialog pttextdialog5 = new pttextdialog(this, "Set Color as Hexstring (RRGGBB)", "Color for Linked Points", globals, "LinkedColor");
                ((Component)pttextdialog5).setVisible(true);
                if (pttextdialog5.result) {
                    this.repaintAll();
                }
            } else if (string2.equals("Single")) {
                pttextdialog pttextdialog6 = new pttextdialog(this, "Set Color as Hexstring (RRGGBB)", "Color for Single Points", globals, "SingleColor");
                ((Component)pttextdialog6).setVisible(true);
                if (pttextdialog6.result) {
                    this.repaintAll();
                }
            }
        }
    }

    void resetScrollPanes() {
        this.project.setdirty();
        this.left.LoadImage(this.left.index);
        this.right.LoadImage(this.right.index);
    }

    void repaintCanvas() {
        this.left.repaint();
        this.right.repaint();
    }

    void repaintAll() {
        this.project.setdirty();
        this.repaintCanvas();
    }

    void LoadImage(String string, ptScrollPane ptScrollPane2) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.project.numIm) {
            if (string.equals("Image" + n)) {
                FileDialog fileDialog = new FileDialog((Frame)this, "Find Image File");
                fileDialog.show();
                string = fileDialog.getFile();
                if (string != null) {
                    ptpicker.globals.utils.setImageName(string, n);
                    this.project.isSaved = false;
                    this.SetImageMenus();
                } else {
                    return;
                }
            }
            ++n;
        }
        n = ptpicker.globals.utils.getIndex(string);
        if (n >= 0 && !ptScrollPane2.LoadImage(n)) {
            ptpicker.globals.utils.setImageName("", n);
            this.SetImageMenus();
        }
    }

    String readScript(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        try {
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray, 0, (int)file.length());
            fileReader.close();
            return new String(cArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        picker = null;
    }
}

