# Pantera Passive Plugin - Check if page has comments
#
# FILENAME      : check_for_ssl.py
# CODER         : Simon Roses Femerling
# DATE          : 06/07/2006
# LAST UPDATE   : 06/07/2006
# ABSTRACT      : Check if page has comments.
#       
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

from panteraPlugins import PPM
import re

plugin_info =  {'id':"CheckForComments",
                'name':"Comment Checker",
                'author':"Simon Roses Femerling",
                'email':"sroses@roseslabs.com",
                'version':"0.1",
                'desc':"Check if page has comments",
                'tag':"comment"  # defined tags else ignore plugin
                } 

class CheckForComments(PPM):
    '''
    CheckForComments class.
    '''
    
    def InitAnalyzer(self):
        '''
        Init function.
        '''
        PPM.__init__(self)
        self.res = 0
    
    def BeginAnalyzer(self,obj):
        '''
        Begin function.
        '''
        self.page_body = obj.printBody(1) # enable gzip decoding
        
        # HTML
        self.exp = re.compile("<!--[^-][\w\W]*?[^-]-->",re.IGNORECASE)
        #self.exp = re.compile("<!--",re.IGNORECASE)
        self.r = self.exp.search(self.page_body)
        if self.r:
            self.msg = "Page has HTML comments!"
            self.SetResultData(self.msg)
            self.res = 1
            
        # Coldfusion
        self.exp = re.compile("<!---[\w\W]*?--->",re.IGNORECASE)
        self.r = self.exp.search(self.page_body)
        if self.r:
            self.msg = "Page has Coldfusion comments!"
            self.SetResultData(self.msg)
            self.res = 1
            
        # Single-line
        self.exp = re.compile("//.*",re.IGNORECASE)
        self.r = self.exp.search(self.page_body)
        if self.r:
            self.msg = "Page has Single Line comments!"
            self.SetResultData(self.msg)
            self.res = 1
            
        # C-Style block 
        self.exp = re.compile("/\*[\w\W]*?\*/",re.IGNORECASE)
        self.r = self.exp.search(self.page_body)
        if self.r:
            self.msg = "Page has C-Style block comments!"
            self.SetResultData(self.msg)
            self.res = 1
            
        # 
        self.exp = re.compile("^'.*",re.IGNORECASE)
        self.r = self.exp.search(self.page_body)
        if self.r:
            self.msg = "Unknown comment format!"
            self.SetResultData(self.msg)
            self.res = 1
            
        # VB 
        self.exp = re.compile("rem\s.*",re.IGNORECASE)
        self.r = self.exp.search(self.page_body)
        if self.r:
            self.msg = "Page has VB comments!"
            self.SetResultData(self.msg)
            self.res = 1
            
        self.SetLevel('info')
        self.SetResult(self.res,'comment')
        
# RL+I EOF