
#import "PopplerCachingRendererTest.h"
#import "TestSettings.h"

// NOTE: as PopplerCachingRendere is based on MkLRUCache we don't
//       test the caching behavior here (eg. what happens if the
//       size of the objects in the cache exceeds the maximum size).
//       MkLRUCache has it's own test in MissingKit so we can "trust"
//       it here.


@implementation PopplerCachingRendererTest

- (id) init
{
   self = [super init];
   if (self)
   {
      renderer = nil;
      document = [[PopplerDocument alloc] initWithPath: kTestDocument];
      renderer = [[PopplerCachingRenderer alloc] initWithDocument: document];
   }
   return self;
}

- (void) dealloc
{
   [renderer release];
   [document release];
}

- (void) testRenderSamePageMultipleTimes
{
   PopplerPage* page = [document page: 1];
   
   id result1 = [renderer renderPage: page scale: 1.0];
   UKNotNil(result1);
   
   int i;
   for (i = 1; i <= 2; i++)
   {
      id result = [renderer renderPage: page scale: 1.0];
      UKNotNil(result);
      UKObjectsSame(result1, result);
   }
}

- (void) testRenderPageSequence
{
   PopplerPage* page1 = [document page: 1];
   PopplerPage* page2 = [document page: 2];
   
   id result1 = [renderer renderPage: page1 scale: 1.0];
   id result2 = [renderer renderPage: page2 scale: 1.0];

   UKNotNil(result1);
   UKNotNil(result2);
   UKObjectsNotSame(result1, result2);
   
   UKObjectsSame(result1, [renderer renderPage: page1 scale: 1.0]);
   UKObjectsSame(result2, [renderer renderPage: page2 scale: 1.0]);
}

- (void) testRenderPageVaryingScale
{
   PopplerPage* page = [document page: 2];
   
   id result1 = [renderer renderPage: page scale: 0.5455];
   id result2 = [renderer renderPage: page scale: 0.5454];

   UKNotNil(result1);
   UKNotNil(result2);

   UKObjectsNotSame(result1, result2);
   
   UKObjectsSame(result1, [renderer renderPage: page scale: 0.5455]);
   UKObjectsSame(result1, [renderer renderPage: page scale: 0.54555]);
}

- (void) testRenderPageVaryingSrcBox
{
   PopplerPage* page = [document page: 1];
   
   NSRect rect1 = NSMakeRect(10, 10, 100, 200);
   NSRect rect2 = NSMakeRect(20, 10, 100, 200);
   
   id result1 = [renderer renderPage: page srcBox: rect1 scale: 0.8];
   id result2 = [renderer renderPage: page srcBox: rect2 scale: 0.8];
   
   UKNotNil(result1);
   UKNotNil(result2);
   
   UKObjectsNotSame(result1, result2);
   
   UKObjectsSame(result1, [renderer renderPage: page srcBox: rect1 scale: 0.8]);
   UKObjectsSame(result2, [renderer renderPage: page srcBox: rect2 scale: 0.8]);
}

@end
