
#import "PopplerDocumentTest.h"
#import "TestSettings.h"
#import <PopplerKit/PopplerKit.h>
#import <Foundation/NSException.h>


@implementation PopplerDocumentTest

- (void) testOpenDocument
{
   PopplerDocument* doc = [PopplerDocument documentWithPath: kTestDocument];
   UKNotNil(doc);
   UKIntsEqual(kTestDocumentPageCount, [doc countPages]);
}

- (void) testOpenNonExistingDocument
{
   NS_DURING
      [PopplerDocument documentWithPath: kNonExistentDocument];
      UKFail();
   NS_HANDLER
      UKStringsEqual(PopplerException, [localException name]);
   NS_ENDHANDLER
}

- (void) testOpenNilPath
{
   NS_DURING
      [PopplerDocument documentWithPath: nil];
      UKFail();
   NS_HANDLER
      UKStringsEqual(NSInvalidArgumentException, [localException name]);
   NS_ENDHANDLER
}

- (void) testGetPages
{
   PopplerDocument* doc = [PopplerDocument documentWithPath: kTestDocument];
   
   int i;
   for (i = 1; i <= [doc countPages]; i++)
   {
      PopplerPage* page = [doc page: i];
      UKNotNil(page);
      UKObjectsSame(page, [doc page: i]);
      UKIntsEqual(i, [page index]);
      UKObjectsSame(doc, [page document]);
   }
}

- (void) testGetPageWithInvalidIndex
{
   PopplerDocument* doc = [PopplerDocument documentWithPath: kTestDocument];

   NS_DURING
      [doc page: 0];
      UKFail();
   NS_HANDLER
      UKStringsEqual(NSInvalidArgumentException, [localException name]);
   NS_ENDHANDLER
   
   NS_DURING
      [doc page: [doc countPages] + 1];
      UKFail();
   NS_HANDLER
      UKStringsEqual(NSInvalidArgumentException, [localException name]);
   NS_ENDHANDLER
}

@end
