
#import "PopplerFontManagerTest.h"
#import "TestSettings.h"
#import <Foundation/NSException.h>
#import <PopplerKit/PopplerKit.h>

@implementation PopplerFontManagerTest

- (void) testFontNames
{
   PopplerFontManager* fm = [PopplerFontManager sharedManager];
   
   NSArray* knownFonts = [fm fontNames];
   UKNotNil(knownFonts);
   UKTrue([knownFonts count] > 0);
   
   // check for helvetica
   NSEnumerator* e = [knownFonts objectEnumerator];
   NSString* aFontName;
   BOOL helveticaFound = NO;
   while ((aFontName = [e nextObject]))
   {
      if ([aFontName isEqualToString: @"Helvetica"])
      {
         helveticaFound = YES;
         break;
      }
   }
   UKTrue(helveticaFound);
   
   NSString* helveticaFile = [fm fontFileFor: @"Helvetica"];
   UKNotNil(helveticaFile);
   UKTrue([[NSFileManager defaultManager] fileExistsAtPath: helveticaFile]);
   
   UKIntsEqual(POPPLER_TYPE1_FONT, [fm fontTypeFor: @"Helvetica"]);
}

- (void) testFontPropertiesForUnknownFont
{
   PopplerFontManager* fm = [PopplerFontManager sharedManager];
   
   UKNil([fm fontFileFor: @"foofont"]);
   UKIntsEqual(POPPLER_UNKNOWN_FONT, [fm fontTypeFor: @"foofont"]);
}

- (void) testSetInvalidFont
{
   PopplerFontManager* fm = [PopplerFontManager sharedManager];
   
   NS_DURING
      [fm setFontFile: @"/nowhere/foofontfile.ttf"
               ofType: POPPLER_TRUETYPE_FONT
              forFont: @"foofont"];
   NS_HANDLER
      UKStringsEqual(NSInvalidArgumentException, [localException name]);
   NS_ENDHANDLER
}

- (void) testSetFonWithInvalidType
{
   PopplerFontManager* fm = [PopplerFontManager sharedManager];
   
   NSString* testFont = [[fm fontNames] objectAtIndex: 0];
   NSString* testFontFile = [fm fontFileFor: testFont];
   
   NS_DURING
      [fm setFontFile: testFontFile
               ofType: POPPLER_UNKNOWN_FONT
              forFont: @"foofont"];
   NS_HANDLER
      UKStringsEqual(NSInvalidArgumentException, [localException name]);
   NS_ENDHANDLER
}

- (void) testSharedInstance
{
   UKObjectsSame([PopplerFontManager sharedManager], [PopplerFontManager sharedManager]);
}

@end
