
#import "PopplerPageTest.h"
#import "TestSettings.h"

@implementation PopplerPageTest

- (id) init
{
   self = [super init];
   if (self)
   {
      document = [[PopplerDocument alloc] initWithPath: kTestDocument];
   }
   return self;
}

- (void) dealloc
{
   [document release];
   [super dealloc];
}

- (void) testPageOrientation
{
   PopplerPage* page = [document page: 1];
   UKIntsEqual(POPPLER_PAGE_ORIENTATION_PORTRAIT, [page orientation]);
}

- (void) testPageSize
{
   PopplerPage* page = [document page: 1];
   NSSize size = [page size];
   UKTrue(size.width > 0.0);
   UKTrue(size.height > 0.0);
   UKTrue(size.height > size.width);
}

@end
