
#import "PopplerRendererTest.h"
#import "TestSettings.h"

@implementation PopplerRendererTest

- (id) init
{
   self = [super init];
   if (self)
   {
      document = [[PopplerDocument alloc] initWithPath: kTestDocument];
      [[NSFileManager defaultManager] createDirectoryAtPath: @"tests/rendered"
                                                 attributes: nil];
   }
   return self;
}

- (void) dealloc
{
   [document release];
   [super dealloc];
}

- (void) testSplashRendererFullPage
{
   PopplerSplashRenderer* renderer = 
      [[PopplerSplashRenderer alloc] initWithDocument: document];
   [renderer autorelease];
   
   PopplerPage* page = [document page: 1];
   NSBitmapImageRep* imageRep = [renderer renderPage: page scale: 1.0];
   UKNotNil(imageRep);
   UKIntsEqual(1, [imageRep retainCount]);

   UKTrue([self saveAsTIFF: imageRep file: @"splash-page.tiff"]);
}

- (void) testSplashRenderSlice
{
   PopplerSplashRenderer* renderer = 
      [[PopplerSplashRenderer alloc] initWithDocument: document];
   [renderer autorelease];

   PopplerPage* page = [document page: 1];
   NSRect box;
   box.origin = NSMakePoint(100, 100);
   box.size.width = [page size].width - 100;
   box.size.height = [page size].height - 100;
   
   NSBitmapImageRep* imageRep = [renderer renderPage: page srcBox: box scale: 1.0];
   UKNotNil(imageRep);
   UKIntsEqual(1, [imageRep retainCount]);

   UKTrue([self saveAsTIFF: imageRep file: @"splash-slice.tiff"]);
}

- (void) testSplashRenderScaled
{
   PopplerSplashRenderer* renderer = 
      [[PopplerSplashRenderer alloc] initWithDocument: document];
   [renderer autorelease];

   PopplerPage* page = [document page: 1];
   NSBitmapImageRep* imageRep = [renderer renderPage: page scale: 0.5];
   UKNotNil(imageRep);
   UKIntsEqual(1, [imageRep retainCount]);
   UKTrue([imageRep size].width <= [page size].width / 2);
   UKTrue([imageRep size].height <= [page size].height / 2);

   UKTrue([self saveAsTIFF: imageRep file: @"splash-scaled.tiff"]);
}

- (void) testCairoImageRendererFullPage
{
   UKTrue([PopplerCairoImageRenderer isSupported]);
   if (![PopplerCairoImageRenderer isSupported])
   {
      return;
   }
   
   PopplerCairoImageRenderer* renderer = 
      [[PopplerCairoImageRenderer alloc] initWithDocument: document];
   [renderer autorelease];
   
   PopplerPage* page = [document page: 1];
   NSBitmapImageRep* imageRep = [renderer renderPage: page scale: 1.0];
   UKNotNil(imageRep);
   UKIntsEqual(1, [imageRep retainCount]);

   UKTrue([self saveAsTIFF: imageRep file: @"cairo-page.tiff"]);
}

- (void) testCairoImageRenderSlice
{
   UKTrue([PopplerCairoImageRenderer isSupported]);
   if (![PopplerCairoImageRenderer isSupported])
   {
      return;
   }

   PopplerCairoImageRenderer* renderer = 
      [[PopplerCairoImageRenderer alloc] initWithDocument: document];
   [renderer autorelease];

   PopplerPage* page = [document page: 1];
   NSRect box;
   box.origin = NSMakePoint(100, 100);
   box.size.width = [page size].width - 100;
   box.size.height = [page size].height - 100;
   
   NSBitmapImageRep* imageRep = [renderer renderPage: page srcBox: box scale: 1.0];
   UKNotNil(imageRep);
   UKIntsEqual(1, [imageRep retainCount]);

   UKTrue([self saveAsTIFF: imageRep file: @"cairo-slice.tiff"]);
}

- (void) testCairoImageRenderScaled
{
   UKTrue([PopplerCairoImageRenderer isSupported]);
   if (![PopplerCairoImageRenderer isSupported])
   {
      return;
   }

   PopplerCairoImageRenderer* renderer = 
      [[PopplerCairoImageRenderer alloc] initWithDocument: document];
   [renderer autorelease];

   PopplerPage* page = [document page: 1];
   NSBitmapImageRep* imageRep = [renderer renderPage: page scale: 0.5];
   UKNotNil(imageRep);
   UKIntsEqual(1, [imageRep retainCount]);
   UKTrue([imageRep size].width <= [page size].width / 2);
   UKTrue([imageRep size].height <= [page size].height / 2);

   UKTrue([self saveAsTIFF: imageRep file: @"cairo-scaled.tiff"]);
}

- (BOOL) saveAsTIFF: (NSBitmapImageRep*)bitmap file: (NSString*)aFilename
{
   NSData* tiffData = nil;
   NS_DURING
      tiffData = [bitmap TIFFRepresentation];
   NS_HANDLER
      return NO;
   NS_ENDHANDLER
   
   if (!tiffData || ([tiffData length] == 0))
   {
      return NO;
   }

   NSString* destDir = @"tests/rendered";
   NSString* destFile = [destDir stringByAppendingPathComponent: aFilename];
   return ([tiffData writeToFile: destFile atomically: NO]);
}

@end
