# print attribute list of any uncoded elements
# Usage: 
#        simple.py < small.xml

import sys

from PyLTXML import *		# NSL interface to XML/SGML
toplevelQuery = unicode(".*/PAIR[TYPE=UNCODED]")
detailQuery = unicode(".[TYPE=UNCODED]")

infile  = FOpen(sys.stdin, NSL_read)

print (infile.doctype.encoding,infile.doctype.xencoding,infile.XMLVersion)

query    = ParseQuery(infile.doctype,toplevelQuery)
subQuery = ParseQuery(infile.doctype,detailQuery)
subtree  = GetNextQueryItem(infile, query)
if not subtree:
  sys.stderr.write("Oops! Nothing found matching '"+toplevelQuery+"'\n")
if subtree.type=='bad':
  sys.stderr.write("Oops! Problems with input file\n")
  subtree=None
while subtree:
	bottomItem = RetrieveQueryItem(subtree,subQuery)
	if bottomItem:
		print ItemActualAttributes(subtree)
	subtree = GetNextQueryItem(infile, query)
  
# (g) Close I/O files
Close(infile)

# ------------
# END OF FILE
# ------------

