/* 
 * Copyright Richard Tobin 1995.
 */

#ifndef HASH_H
#define HASH_H

typedef struct hash_entry {
    char *key;
    void *value;
    struct hash_entry *next;
} *HashEntry;

typedef struct hash_table *HashTable;

HashTable create_hash_table(int init_size, int key_size);
void free_hash_table(HashTable table);
HashEntry hash_find(HashTable table, char *key);
HashEntry hash_find_or_add(HashTable table, char *key, int *foundp);
void hash_remove(HashTable table, HashEntry entry);
void hash_map(HashTable table, void (*function)(HashEntry));
int hash_count(HashTable table);

#endif /* HASH_H */
