"""Distutils setup for PyLTXML
   $Id: setup.py,v 1.8 2002/08/23 14:38:07 ht Exp $"""

import sys

from distutils.core import setup, Extension
from distutils.command.install_data import install_data

#data installer with improved intelligence over distutils.
#data files are copied into the project directory instead
#of willy-nilly
class smart_install_data(install_data):
  def run(self):
    #need to change self.install_dir to the actual library dir
    install_cmd = self.get_finalized_command('install')
    self.install_dir = getattr(install_cmd, 'install_lib')
    return install_data.run(self)

datafiles=[('PyLTXML/example',
            ['example/small.xml',
             'example/gscore.dtd',
             'example/simple.py'])] # only works for bdist and friends

if sys.platform.find("win32",0,5)==0:
  incldirs=['C:\Program Files\HCRC LTG\LT XML\include']
  libdirs=['C:\Program Files\HCRC LTG\LT XML\lib']
  libs=['ltapi12','ltstd12']
  macros=[('FOR_LT', '1'),('CHAR_SIZE', '16'), ('WIN32', '1')]

  extra_link_args=[]
  extra_compile_args=[]

  datafiles.append(('PyLTXML',
                    ['c:\\Program Files\\HCRC LTG\\LT XML\\bin\ltstd12.dll',
                     'c:\\Program Files\\HCRC LTG\\LT XML\\bin\ltapi12.dll']))

  platform="WIN32"
else:
  incldirs=['/group/ltg/projects/lcontrib9/include/ltxml12']
  libdirs=['/group/ltg/projects/lcontrib9/lib']
  libs=['ltapi12','ltstd12', 'z']
  macros=[('FOR_LT', '1')] # ,('ALLOC_DEBUG', '1')

  if sys.platform.find("sunos",0,5)==0:
    extra_link_args=['-mimpure-text']
    extra_compile_args=['-mimpure-text']
  else:
    extra_link_args=[]
    extra_compile_args=[]

  platform="UN*X"

pyltxml = Extension('PyLTXML.LTXMLinter',
                    sources = ['alloc.c','block_alloc.c',
                               'hash.c', 'NSLintermodule.c'],
                    include_dirs = incldirs,
                    library_dirs = libdirs,
                    libraries = libs,
                    define_macros = macros,
                    extra_link_args = extra_link_args,
                    extra_compile_args = extra_compile_args)

setup(name='PyLTXML',
      version='1.3',
      description='Python binding for LT XML',
      author='Henry S. Thompson',
      author_email='HThompson@ed.ac.uk',
      url="http://www.ltg.ed.ac.uk/software/xml",
      license="GPL",
      long_description="""Exposes a Python-level interface to the LTG's
      high-speed C-language validating XML parser.
      See 00README for details""",
      platforms=[platform],
      packages=['PyLTXML'],
      cmdclass = {'install_data': smart_install_data},
      data_files=datafiles,
      ext_modules=[pyltxml])
