/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SimilarityDelegator;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.PriorityQueue;

public class FuzzyLikeThisQuery
extends Query {
    static Similarity sim = new DefaultSimilarity();
    Query rewrittenQuery = null;
    ArrayList fieldVals = new ArrayList();
    Analyzer analyzer;
    ScoreTermQueue q;
    int MAX_VARIANTS_PER_TERM = 50;
    boolean ignoreTF = false;

    public FuzzyLikeThisQuery(int maxNumTerms, Analyzer analyzer) {
        this.q = new ScoreTermQueue(maxNumTerms);
        this.analyzer = analyzer;
    }

    public void addTerms(String queryString, String fieldName, float minSimilarity, int prefixLength) {
        this.fieldVals.add(new FieldVals(fieldName, minSimilarity, prefixLength, queryString));
    }

    private void addTerms(IndexReader reader, FieldVals f) throws IOException {
        if (f.queryString == null) {
            return;
        }
        TokenStream ts = this.analyzer.tokenStream(f.fieldName, (Reader)new StringReader(f.queryString));
        Token token = ts.next();
        int corpusNumDocs = reader.numDocs();
        Term internSavingTemplateTerm = new Term(f.fieldName, "");
        HashSet<String> processedTerms = new HashSet<String>();
        while (token != null) {
            if (!processedTerms.contains(token.termText())) {
                processedTerms.add(token.termText());
                ScoreTermQueue variantsQ = new ScoreTermQueue(this.MAX_VARIANTS_PER_TERM);
                float minScore = 0.0f;
                Term startTerm = internSavingTemplateTerm.createTerm(token.termText());
                FuzzyTermEnum fe = new FuzzyTermEnum(reader, startTerm, f.minSimilarity, f.prefixLength);
                TermEnum origEnum = reader.terms(startTerm);
                int df = 0;
                if (startTerm.equals((Object)origEnum.term())) {
                    df = origEnum.docFreq();
                }
                int numVariants = 0;
                int totalVariantDocFreqs = 0;
                do {
                    Term possibleMatch;
                    if ((possibleMatch = fe.term()) == null) continue;
                    ++numVariants;
                    totalVariantDocFreqs += fe.docFreq();
                    float score = fe.difference();
                    if (variantsQ.size() >= this.MAX_VARIANTS_PER_TERM && !(score > minScore)) continue;
                    ScoreTerm st = new ScoreTerm(possibleMatch, score, startTerm);
                    variantsQ.insert(st);
                    minScore = ((ScoreTerm)variantsQ.top()).score;
                } while (fe.next());
                if (numVariants == 0) break;
                int avgDf = totalVariantDocFreqs / numVariants;
                if (df == 0) {
                    df = avgDf;
                }
                int size = variantsQ.size();
                for (int i = 0; i < size; ++i) {
                    ScoreTerm st = (ScoreTerm)variantsQ.pop();
                    st.score = st.score * st.score * sim.idf(df, corpusNumDocs);
                    this.q.insert(st);
                }
            }
            token = ts.next();
        }
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenQuery != null) {
            return this.rewrittenQuery;
        }
        Iterator iter = this.fieldVals.iterator();
        while (iter.hasNext()) {
            FieldVals f = (FieldVals)iter.next();
            this.addTerms(reader, f);
        }
        this.fieldVals.clear();
        BooleanQuery bq = new BooleanQuery();
        HashMap<Term, ArrayList<ScoreTerm>> variantQueries = new HashMap<Term, ArrayList<ScoreTerm>>();
        int size = this.q.size();
        for (int i = 0; i < size; ++i) {
            ScoreTerm st = (ScoreTerm)this.q.pop();
            ArrayList<ScoreTerm> l = (ArrayList<ScoreTerm>)variantQueries.get(st.fuzziedSourceTerm);
            if (l == null) {
                l = new ArrayList<ScoreTerm>();
                variantQueries.put(st.fuzziedSourceTerm, l);
            }
            l.add(st);
        }
        Iterator iter2 = variantQueries.values().iterator();
        while (iter2.hasNext()) {
            ArrayList variants = (ArrayList)iter2.next();
            if (variants.size() == 1) {
                ScoreTerm st = (ScoreTerm)variants.get(0);
                FuzzyTermQuery tq = new FuzzyTermQuery(st.term, this.ignoreTF);
                tq.setBoost(st.score);
                bq.add((Query)tq, BooleanClause.Occur.SHOULD);
                continue;
            }
            BooleanQuery termVariants = new BooleanQuery(true);
            Iterator iterator2 = variants.iterator();
            while (iterator2.hasNext()) {
                ScoreTerm st = (ScoreTerm)iterator2.next();
                FuzzyTermQuery tq = new FuzzyTermQuery(st.term, this.ignoreTF);
                tq.setBoost(st.score);
                termVariants.add((Query)tq, BooleanClause.Occur.SHOULD);
            }
            bq.add((Query)termVariants, BooleanClause.Occur.SHOULD);
        }
        this.rewrittenQuery = bq;
        return bq;
    }

    public String toString(String field) {
        return null;
    }

    public boolean isIgnoreTF() {
        return this.ignoreTF;
    }

    public void setIgnoreTF(boolean ignoreTF) {
        this.ignoreTF = ignoreTF;
    }

    private static class FuzzyTermQuery
    extends TermQuery {
        boolean ignoreTF;

        public FuzzyTermQuery(Term t, boolean ignoreTF) {
            super(t);
            this.ignoreTF = ignoreTF;
        }

        public Similarity getSimilarity(Searcher searcher) {
            Object result = super.getSimilarity(searcher);
            result = new SimilarityDelegator((Similarity)result){

                public float tf(float freq) {
                    if (FuzzyTermQuery.this.ignoreTF) {
                        return 1.0f;
                    }
                    return super.tf(freq);
                }

                public float idf(int docFreq, int numDocs) {
                    return 1.0f;
                }
            };
            return result;
        }
    }

    private static class ScoreTermQueue
    extends PriorityQueue {
        public ScoreTermQueue(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(Object a, Object b) {
            ScoreTerm termA = (ScoreTerm)a;
            ScoreTerm termB = (ScoreTerm)b;
            if (termA.score == termB.score) {
                return termA.term.compareTo(termB.term) > 0;
            }
            return termA.score < termB.score;
        }
    }

    private static class ScoreTerm {
        public Term term;
        public float score;
        Term fuzziedSourceTerm;

        public ScoreTerm(Term term, float score, Term fuzziedSourceTerm) {
            this.term = term;
            this.score = score;
            this.fuzziedSourceTerm = fuzziedSourceTerm;
        }
    }

    class FieldVals {
        String queryString;
        String fieldName;
        float minSimilarity;
        int prefixLength;

        public FieldVals(String name, float similarity, int length, String queryString) {
            this.fieldName = name;
            this.minSimilarity = similarity;
            this.prefixLength = length;
            this.queryString = queryString;
        }
    }
}

