/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Posting;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;

final class DocumentWriter {
    private Analyzer analyzer;
    private Directory directory;
    private Similarity similarity;
    private FieldInfos fieldInfos;
    private int maxFieldLength;
    private int termIndexInterval = 128;
    private PrintStream infoStream;
    private final Hashtable postingTable = new Hashtable();
    private int[] fieldLengths;
    private int[] fieldPositions;
    private int[] fieldOffsets;
    private float[] fieldBoosts;
    private final Term termBuffer = new Term("", "");

    DocumentWriter(Directory directory, Analyzer analyzer, Similarity similarity, int maxFieldLength) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.maxFieldLength = maxFieldLength;
    }

    DocumentWriter(Directory directory, Analyzer analyzer, IndexWriter writer) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = writer.getSimilarity();
        this.maxFieldLength = writer.getMaxFieldLength();
        this.termIndexInterval = writer.getTermIndexInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDocument(String segment, Document doc) throws IOException {
        this.fieldInfos = new FieldInfos();
        this.fieldInfos.add(doc);
        this.fieldInfos.write(this.directory, segment + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, segment, this.fieldInfos);
        try {
            fieldsWriter.addDocument(doc);
        }
        finally {
            fieldsWriter.close();
        }
        this.postingTable.clear();
        this.fieldLengths = new int[this.fieldInfos.size()];
        this.fieldPositions = new int[this.fieldInfos.size()];
        this.fieldOffsets = new int[this.fieldInfos.size()];
        this.fieldBoosts = new float[this.fieldInfos.size()];
        Arrays.fill(this.fieldBoosts, doc.getBoost());
        this.invertDocument(doc);
        Posting[] postings = this.sortPostingTable();
        this.writePostings(postings, segment);
        this.writeNorms(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invertDocument(Document doc) throws IOException {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            Fieldable field = (Fieldable)fields.nextElement();
            String fieldName = field.name();
            int fieldNumber = this.fieldInfos.fieldNumber(fieldName);
            int length = this.fieldLengths[fieldNumber];
            int position = this.fieldPositions[fieldNumber];
            if (length > 0) {
                position += this.analyzer.getPositionIncrementGap(fieldName);
            }
            int offset = this.fieldOffsets[fieldNumber];
            if (!field.isIndexed()) continue;
            if (!field.isTokenized()) {
                String stringValue = field.stringValue();
                if (field.isStoreOffsetWithTermVector()) {
                    this.addPosition(fieldName, stringValue, position++, new TermVectorOffsetInfo(offset, offset + stringValue.length()));
                } else {
                    this.addPosition(fieldName, stringValue, position++, null);
                }
                offset += stringValue.length();
            } else {
                Reader reader;
                if (field.readerValue() != null) {
                    reader = field.readerValue();
                } else if (field.stringValue() != null) {
                    reader = new StringReader(field.stringValue());
                } else {
                    throw new IllegalArgumentException("field must have either String or Reader value");
                }
                TokenStream stream = this.analyzer.tokenStream(fieldName, reader);
                try {
                    Token lastToken = null;
                    Token t = stream.next();
                    while (t != null) {
                        position += t.getPositionIncrement() - 1;
                        if (field.isStoreOffsetWithTermVector()) {
                            this.addPosition(fieldName, t.termText(), position++, new TermVectorOffsetInfo(offset + t.startOffset(), offset + t.endOffset()));
                        } else {
                            this.addPosition(fieldName, t.termText(), position++, null);
                        }
                        lastToken = t;
                        if (++length >= this.maxFieldLength) {
                            if (this.infoStream == null) break;
                            this.infoStream.println("maxFieldLength " + this.maxFieldLength + " reached, ignoring following tokens");
                            break;
                        }
                        t = stream.next();
                    }
                    if (lastToken != null) {
                        offset += lastToken.endOffset() + 1;
                    }
                }
                finally {
                    stream.close();
                }
            }
            this.fieldLengths[fieldNumber] = ++length;
            this.fieldPositions[fieldNumber] = position;
            int n = fieldNumber;
            this.fieldBoosts[n] = this.fieldBoosts[n] * field.getBoost();
            this.fieldOffsets[fieldNumber] = offset;
        }
    }

    private final void addPosition(String field, String text, int position, TermVectorOffsetInfo offset) {
        this.termBuffer.set(field, text);
        Posting ti = (Posting)this.postingTable.get(this.termBuffer);
        if (ti != null) {
            int freq = ti.freq;
            if (ti.positions.length == freq) {
                int[] newPositions = new int[freq * 2];
                int[] positions = ti.positions;
                System.arraycopy(positions, 0, newPositions, 0, freq);
                ti.positions = newPositions;
            }
            ti.positions[freq] = position;
            if (offset != null) {
                if (ti.offsets.length == freq) {
                    TermVectorOffsetInfo[] newOffsets = new TermVectorOffsetInfo[freq * 2];
                    TermVectorOffsetInfo[] offsets = ti.offsets;
                    System.arraycopy(offsets, 0, newOffsets, 0, freq);
                    ti.offsets = newOffsets;
                }
                ti.offsets[freq] = offset;
            }
            ti.freq = freq + 1;
        } else {
            Term term = new Term(field, text, false);
            this.postingTable.put(term, new Posting(term, position, offset));
        }
    }

    private final Posting[] sortPostingTable() {
        Posting[] array = new Posting[this.postingTable.size()];
        Enumeration postings = this.postingTable.elements();
        int i = 0;
        while (postings.hasMoreElements()) {
            array[i] = (Posting)postings.nextElement();
            ++i;
        }
        DocumentWriter.quickSort(array, 0, array.length - 1);
        return array;
    }

    private static final void quickSort(Posting[] postings, int lo, int hi) {
        int right;
        int left;
        Posting tmp;
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        if (postings[lo].term.compareTo(postings[mid].term) > 0) {
            tmp = postings[lo];
            postings[lo] = postings[mid];
            postings[mid] = tmp;
        }
        if (postings[mid].term.compareTo(postings[hi].term) > 0) {
            tmp = postings[mid];
            postings[mid] = postings[hi];
            postings[hi] = tmp;
            if (postings[lo].term.compareTo(postings[mid].term) > 0) {
                Posting tmp2 = postings[lo];
                postings[lo] = postings[mid];
                postings[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        Term partition = postings[mid].term;
        while (true) {
            if (postings[right].term.compareTo(partition) > 0) {
                --right;
                continue;
            }
            while (left < right && postings[left].term.compareTo(partition) <= 0) {
                ++left;
            }
            if (left >= right) break;
            Posting tmp2 = postings[left];
            postings[left] = postings[right];
            postings[right] = tmp2;
            --right;
        }
        DocumentWriter.quickSort(postings, lo, left);
        DocumentWriter.quickSort(postings, left + 1, hi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writePostings(Posting[] postings, String segment) throws IOException {
        IOException keep2;
        block36: {
            IOException e22;
            TermVectorsWriter termVectorWriter;
            block35: {
                TermInfosWriter tis;
                block34: {
                    IndexOutput prox;
                    block33: {
                        IndexOutput freq = null;
                        prox = null;
                        tis = null;
                        termVectorWriter = null;
                        try {
                            freq = this.directory.createOutput(segment + ".frq");
                            prox = this.directory.createOutput(segment + ".prx");
                            tis = new TermInfosWriter(this.directory, segment, this.fieldInfos, this.termIndexInterval);
                            TermInfo ti = new TermInfo();
                            String currentField = null;
                            for (int i = 0; i < postings.length; ++i) {
                                Posting posting = postings[i];
                                ti.set(1, freq.getFilePointer(), prox.getFilePointer(), -1);
                                tis.add(posting.term, ti);
                                int postingFreq = posting.freq;
                                if (postingFreq == 1) {
                                    freq.writeVInt(1);
                                } else {
                                    freq.writeVInt(0);
                                    freq.writeVInt(postingFreq);
                                }
                                int lastPosition = 0;
                                int[] positions = posting.positions;
                                for (int j = 0; j < postingFreq; ++j) {
                                    int position = positions[j];
                                    prox.writeVInt(position - lastPosition);
                                    lastPosition = position;
                                }
                                String termField = posting.term.field();
                                if (currentField != termField) {
                                    currentField = termField;
                                    FieldInfo fi = this.fieldInfos.fieldInfo(currentField);
                                    if (fi.storeTermVector) {
                                        if (termVectorWriter == null) {
                                            termVectorWriter = new TermVectorsWriter(this.directory, segment, this.fieldInfos);
                                            termVectorWriter.openDocument();
                                        }
                                        termVectorWriter.openField(currentField);
                                    } else if (termVectorWriter != null) {
                                        termVectorWriter.closeField();
                                    }
                                }
                                if (termVectorWriter == null || !termVectorWriter.isFieldOpen()) continue;
                                termVectorWriter.addTerm(posting.term.text(), postingFreq, posting.positions, posting.offsets);
                            }
                            if (termVectorWriter != null) {
                                termVectorWriter.closeDocument();
                            }
                            Object var17_18 = null;
                            keep2 = null;
                            if (freq == null) break block33;
                        }
                        catch (Throwable throwable) {
                            IOException keep2;
                            block40: {
                                IOException e22;
                                block39: {
                                    block38: {
                                        block37: {
                                            Object var17_19 = null;
                                            keep2 = null;
                                            if (freq != null) {
                                                try {
                                                    freq.close();
                                                }
                                                catch (IOException e22) {
                                                    if (keep2 != null) break block37;
                                                    keep2 = e22;
                                                }
                                            }
                                        }
                                        if (prox != null) {
                                            try {
                                                prox.close();
                                            }
                                            catch (IOException e22) {
                                                if (keep2 != null) break block38;
                                                keep2 = e22;
                                            }
                                        }
                                    }
                                    if (tis != null) {
                                        try {
                                            tis.close();
                                        }
                                        catch (IOException e22) {
                                            if (keep2 != null) break block39;
                                            keep2 = e22;
                                        }
                                    }
                                }
                                if (termVectorWriter != null) {
                                    try {
                                        termVectorWriter.close();
                                    }
                                    catch (IOException e22) {
                                        if (keep2 != null) break block40;
                                        keep2 = e22;
                                    }
                                }
                            }
                            if (keep2 != null) {
                                throw (IOException)keep2.fillInStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            freq.close();
                        }
                        catch (IOException e22) {
                            if (keep2 != null) break block33;
                            keep2 = e22;
                        }
                    }
                    if (prox != null) {
                        try {
                            prox.close();
                        }
                        catch (IOException e22) {
                            if (keep2 != null) break block34;
                            keep2 = e22;
                        }
                    }
                }
                if (tis != null) {
                    try {
                        tis.close();
                    }
                    catch (IOException e22) {
                        if (keep2 != null) break block35;
                        keep2 = e22;
                    }
                }
            }
            if (termVectorWriter != null) {
                try {
                    termVectorWriter.close();
                }
                catch (IOException e22) {
                    if (keep2 != null) break block36;
                    keep2 = e22;
                }
            }
        }
        if (keep2 != null) {
            throw (IOException)keep2.fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeNorms(String segment) throws IOException {
        for (int n = 0; n < this.fieldInfos.size(); ++n) {
            FieldInfo fi = this.fieldInfos.fieldInfo(n);
            if (!fi.isIndexed || fi.omitNorms) continue;
            float norm = this.fieldBoosts[n] * this.similarity.lengthNorm(fi.name, this.fieldLengths[n]);
            IndexOutput norms = this.directory.createOutput(segment + ".f" + n);
            try {
                norms.writeByte(Similarity.encodeNorm(norm));
                continue;
            }
            finally {
                norms.close();
            }
        }
    }

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }
}

